/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.io.File;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.db.DBTableModelUtil;
import org.opengion.hayabusa.servlet.MultipartRequest;
import org.opengion.hayabusa.taglib.CommonTagSupport;

public class FileUploadTag
extends CommonTagSupport {
    private static final String VERSION = "5.6.6.1 (2013/07/12)";
    private static final long serialVersionUID = 566120130712L;
    private static final String[] names = new String[]{"KEY", "VALUE", "ISFILE"};
    private static final String ENCODE = "UTF-8";
    private String fileURL = HybsSystem.sys("FILE_URL");
    private String filename = null;
    private int maxPostSize = 0xA00000;
    private String tableId = "h_tblmdl";
    private String columns = null;
    private boolean useBackup = false;

    @Override
    public int doEndTag() {
        this.debugPrint();
        this.startQueryTransaction(this.tableId);
        HttpServletRequest httpServletRequest = (HttpServletRequest)this.getRequest();
        try {
            String string = HybsSystem.url2dir(this.fileURL);
            File file = new File(string);
            if (!file.exists() && !file.mkdirs()) {
                String string2 = "\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002[" + string + "]";
                throw new HybsSystemException(string2);
            }
            MultipartRequest multipartRequest = new MultipartRequest(httpServletRequest, string, this.maxPostSize, ENCODE, this.filename, this.useBackup);
            DBTableModel dBTableModel = null;
            dBTableModel = this.columns == null ? this.makeDBTable(multipartRequest) : this.makeDBTableFromClms(multipartRequest);
            if (!this.commitTableObject(this.tableId, dBTableModel)) {
                this.jspPrint("FileUploadTag Query\u51e6\u7406\u304c\u5272\u308a\u8fbc\u307e\u308c\u307e\u3057\u305f\u3002DBTableModel \u306f\u767b\u9332\u3057\u307e\u305b\u3093\u3002");
                return 5;
            }
        }
        catch (IOException iOException) {
            String string = "\u30d5\u30a1\u30a4\u30eb\u767b\u9332\u30a8\u30e9\u30fc\uff01" + iOException.getMessage() + HybsSystem.CR + "(" + this.toString() + HybsSystem.CR + "FileURL=" + this.fileURL + ")";
            throw new HybsSystemException(string, iOException);
        }
        return 6;
    }

    @Override
    protected void release2() {
        super.release2();
        this.fileURL = HybsSystem.sys("FILE_URL");
        this.maxPostSize = 0xA00000;
        this.tableId = "h_tblmdl";
        this.filename = null;
        this.columns = null;
        this.useBackup = false;
    }

    private DBTableModel makeDBTable(MultipartRequest multipartRequest) {
        String string;
        Object object;
        Object object2;
        DBTableModel dBTableModel = DBTableModelUtil.newDBTable();
        dBTableModel.init(names.length);
        for (int i = 0; i < names.length; ++i) {
            object2 = this.getDBColumn(names[i]);
            dBTableModel.setDBColumn(i, (DBColumn)object2);
        }
        object2 = multipartRequest.getFilenames();
        for (int i = 0; i < ((String[])object2).length; ++i) {
            String string2 = object2[i];
            object = multipartRequest.getFile(string2);
            if (object == null) continue;
            string = multipartRequest.getFilesystemName(string2);
            String[] stringArray = new String[]{string2, string, "1"};
            dBTableModel.addColumnValues(stringArray);
            this.setRequestAttribute(string2, string);
            String string3 = string2 + "_ORG";
            string = multipartRequest.getOriginalFileName(string2);
            stringArray = new String[]{string3, string, "2"};
            dBTableModel.addColumnValues(stringArray);
            this.setRequestAttribute(string3, string);
        }
        String[] stringArray = new String[]{"directory", this.fileURL, "0"};
        dBTableModel.addColumnValues(stringArray);
        this.setRequestAttribute("directory", this.fileURL);
        String[] stringArray2 = multipartRequest.getParameterNames();
        for (int i = 0; i < stringArray2.length; ++i) {
            object = stringArray2[i];
            if ("h_rowSel".equals(object)) {
                this.setRequestAttribute((String)object, multipartRequest.getIntParameters((String)object));
                continue;
            }
            string = this.getParamVal((String)object, multipartRequest);
            stringArray = new String[]{object, string, "0"};
            dBTableModel.addColumnValues(stringArray);
            this.setRequestAttribute((String)object, string);
        }
        String[] stringArray3 = new String[((String[])object2).length + stringArray2.length];
        System.arraycopy(object2, 0, stringArray3, 0, ((String[])object2).length);
        System.arraycopy(stringArray2, 0, stringArray3, ((String[])object2).length, stringArray2.length);
        this.setParameterNames(stringArray3);
        return dBTableModel;
    }

    private DBTableModel makeDBTableFromClms(MultipartRequest multipartRequest) {
        String[] stringArray;
        Object object;
        Object object2;
        DBTableModel dBTableModel = DBTableModelUtil.newDBTable();
        String[] stringArray2 = this.columns.split(",");
        dBTableModel.init(stringArray2.length);
        String[] stringArray3 = new String[stringArray2.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            String string = stringArray2[i];
            object2 = this.getDBColumn(string);
            dBTableModel.setDBColumn(i, (DBColumn)object2);
            object = this.getParamVal(string, multipartRequest);
            if (object == null) {
                object = multipartRequest.getFilesystemName(string);
            }
            if (object == null) {
                object = multipartRequest.getOriginalFileName(string);
            }
            stringArray3[i] = object == null ? "" : object;
        }
        String[] stringArray4 = multipartRequest.getFilenames();
        for (int i = 0; i < stringArray4.length; ++i) {
            object2 = stringArray4[i];
            object = multipartRequest.getFile((String)object2);
            if (object == null) continue;
            stringArray = new String[stringArray2.length];
            System.arraycopy(stringArray3, 0, stringArray, 0, stringArray.length);
            String string = multipartRequest.getFilesystemName((String)object2);
            this.setRequestAttribute((String)object2, string);
            String string2 = (String)object2 + "_ORG";
            String string3 = multipartRequest.getOriginalFileName((String)object2);
            this.setRequestAttribute(string2, string3);
            int n = ((String)object2).lastIndexOf(95);
            if (n > 0) {
                String string4 = ((String)object2).substring(0, n);
                String string5 = ((String)object2).substring(n);
                for (int j = 0; j < stringArray2.length; ++j) {
                    String string6 = stringArray2[j];
                    String string7 = null;
                    String string8 = null;
                    if (string4.equalsIgnoreCase(string6)) {
                        string8 = string;
                    } else if ((string4 + "_ORG").equalsIgnoreCase(string6)) {
                        string8 = string3;
                    } else if ((string4 + "_NEW").equalsIgnoreCase(string6)) {
                        string7 = (String)object2 + "_NEW";
                        string8 = multipartRequest.getParameter(string7);
                    } else {
                        string7 = stringArray2[j] + string5;
                        string8 = this.getParamVal(string7, multipartRequest);
                    }
                    if (string8 == null) continue;
                    stringArray[j] = string8;
                }
            }
            dBTableModel.addColumnValues(stringArray);
        }
        this.setRequestAttribute("directory", this.fileURL);
        String[] stringArray5 = multipartRequest.getParameterNames();
        for (int i = 0; i < stringArray5.length; ++i) {
            object = stringArray5[i];
            if ("h_rowSel".equals(object)) {
                this.setRequestAttribute((String)object, multipartRequest.getIntParameters((String)object));
                continue;
            }
            stringArray = this.getParamVal((String)object, multipartRequest);
            this.setRequestAttribute((String)object, stringArray);
        }
        String[] stringArray6 = new String[stringArray4.length + stringArray5.length];
        System.arraycopy(stringArray4, 0, stringArray6, 0, stringArray4.length);
        System.arraycopy(stringArray5, 0, stringArray6, stringArray4.length, stringArray5.length);
        this.setParameterNames(stringArray6);
        return dBTableModel;
    }

    private String getParamVal(String string, MultipartRequest multipartRequest) {
        String[] stringArray;
        String string2 = multipartRequest.getParameter(string);
        if ("0".equals(string2) && (stringArray = multipartRequest.getParameters(string)) != null && stringArray.length > 1) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!"1".equals(stringArray[i])) continue;
                string2 = "1";
                break;
            }
        }
        return string2;
    }

    public void setFileURL(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string2 != null) {
            char c = string2.charAt(string2.length() - 1);
            if (c != '/' && c != '\\') {
                string2 = string2 + "/";
            }
            this.fileURL = StringUtil.urlAppend((String)this.fileURL, (String)string2, (String[])new String[0]);
        }
    }

    public void setMaxPostSize(String string) {
        this.maxPostSize = StringUtil.nval((String)this.getRequestParameter(string), (int)this.maxPostSize);
    }

    public void setTableId(String string) {
        this.tableId = StringUtil.nval((String)this.getRequestParameter(string), (String)this.tableId);
    }

    public void setFilename(String string) {
        this.filename = StringUtil.nval((String)this.getRequestParameter(string), (String)this.filename);
    }

    public void setColumns(String string) {
        this.columns = StringUtil.nval((String)this.getRequestParameter(string), (String)this.columns);
    }

    public void setUseBackup(String string) {
        this.useBackup = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useBackup);
    }

    @Override
    protected String getTagName() {
        return "upload";
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("names", (Object[])names).println("ENCODE", (Object)ENCODE).println("fileURL", (Object)this.fileURL).println("filename", (Object)this.filename).println("maxPostSize", (Object)this.maxPostSize).println("tableId", (Object)this.tableId).println("columns", (Object)this.columns).println("useBackup", (Object)this.useBackup).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }
}

