/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Locale;
import javax.servlet.jsp.tagext.Tag;
import org.opengion.fukurou.db.DBUtil;
import org.opengion.fukurou.db.Transaction;
import org.opengion.fukurou.db.TransactionReal;
import org.opengion.fukurou.util.ErrorMessage;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.hayabusa.db.DBEditConfig;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.db.Query;
import org.opengion.hayabusa.db.QueryFactory;
import org.opengion.hayabusa.resource.GUIInfo;
import org.opengion.hayabusa.taglib.CommonTagSupport;
import org.opengion.hayabusa.taglib.TaglibUtil;
import org.opengion.hayabusa.taglib.TransactionTag;

public class QueryTag
extends CommonTagSupport {
    private static final String VERSION = "4.0.0 (2005/08/31)";
    private static final long serialVersionUID = 4000L;
    public static final String CMD_NEW = "NEW";
    public static final String CMD_RENEW = "RENEW";
    private static final String[] COMMAND_LIST = new String[]{"NEW", "RENEW"};
    protected static final String errMsgId = "h_errMsg";
    private String queryType = null;
    private String dbid = null;
    protected transient DBTableModel table = null;
    protected transient ErrorMessage errMessage = null;
    protected String tableId = "h_tblmdl";
    protected String command = "NEW";
    protected int skipRowCount = 0;
    protected int maxRowCount = -1;
    protected String sql = null;
    protected int executeCount = -1;
    protected String names = null;
    protected boolean outMessage = true;
    protected int errCode = 0;
    protected boolean quotCheck = HybsSystem.sysBool("USE_SQL_INJECTION_CHECK");
    private boolean trace = false;
    private boolean stopZero = false;
    private String modifyType = null;
    protected String displayMsg = HybsSystem.sys("VIEW_DISPLAY_MSG");
    private String overflowMsg = "MSG0007";
    private String notfoundMsg = "MSG0077";
    private boolean isMainTrans = true;
    protected long dyStart = 0L;
    protected boolean stopError = true;
    private StringBuilder debugMsg = null;
    private String checkNames = null;
    private String traceMsg = null;
    protected boolean xssCheck = HybsSystem.sysBool("USE_XSS_CHECK");
    private boolean useBeforeHtmlTag = true;

    @Override
    public int doStartTag() {
        if (this.useTag()) {
            this.dyStart = System.currentTimeMillis();
            if (!this.check(this.command, COMMAND_LIST)) {
                return 0;
            }
            this.useMainTrans(this.isMainTrans);
            this.startQueryTransaction(this.tableId);
            if ("session".equals(this.getScope())) {
                this.removeSessionAttribute(this.tableId);
                this.removeSessionAttribute("h_vform");
            }
            return 2;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int doAfterBody() {
        this.useQuotCheck(this.quotCheck);
        this.useXssCheck(this.xssCheck);
        this.sql = this.getBodyString().trim();
        if (this.isMainTrans) {
            this.setUserInfo("LASTSQL", this.sql, false);
            this.setUserInfo("LASTQUERYTYPE", this.queryType, false);
            this.setUserInfo("LASTNAMES", this.names, false);
        }
        Query query = QueryFactory.newInstance(this.queryType);
        Object object = null;
        try {
            TransactionTag transactionTag;
            if (this.maxRowCount < 0) {
                this.maxRowCount = this.sysInt("DB_MAX_ROW_COUNT");
            }
            object = (transactionTag = (TransactionTag)QueryTag.findAncestorWithClass((Tag)this, TransactionTag.class)) == null ? new TransactionReal(this.getApplicationInfo()) : transactionTag.getTransaction();
            query.setTransaction(this.dbid, (Transaction)object);
            query.setSkipRowCount(this.skipRowCount);
            query.setMaxRowCount(this.maxRowCount);
            query.setResourceManager(this.getResource());
            if (this.trace) {
                this.traceMsg = this.traceQuery(this.sql, (Transaction)object);
                int n = 0;
                return n;
            }
            query.setStatement(this.sql);
            if (this.isMainTrans) {
                String string = this.getGUIInfoAttri("KEY");
                String string2 = this.getRequestValue("editName");
                DBEditConfig dBEditConfig = this.getUser().getEditConfig(string, string2);
                if (dBEditConfig != null) {
                    query.setEditConfig(dBEditConfig);
                }
            }
            this.execute(query);
            this.executeCount = query.getExecuteCount();
            if (this.errCode < 2 && this.executeCount >= 0) {
                this.table = query.getDBTableModel();
                if (this.modifyType != null) {
                    for (int i = 0; i < this.executeCount; ++i) {
                        this.table.setModifyType(i, this.modifyType);
                    }
                }
            }
        }
        finally {
            QueryFactory.close(query);
            if (object != null) {
                object.close();
            }
        }
        return 0;
    }

    @Override
    public int doEndTag() {
        GUIInfo gUIInfo;
        this.debugPrint();
        if (!this.useTag()) {
            return 6;
        }
        if (this.trace) {
            this.jspPrint(this.traceMsg);
            return 5;
        }
        String string = "";
        if (this.check(this.command, COMMAND_LIST)) {
            String string2;
            StringBuilder stringBuilder = new StringBuilder(50);
            if (CMD_NEW.equals(this.command)) {
                if (this.executeCount > 0 && this.displayMsg != null && this.displayMsg.length() > 0) {
                    stringBuilder.append(this.executeCount);
                    stringBuilder.append(this.getResource().getLabel(this.displayMsg));
                    stringBuilder.append(HybsSystem.BR);
                } else if (this.executeCount == 0 && this.notfoundMsg != null && this.notfoundMsg.length() > 0) {
                    stringBuilder.append(this.getResource().getLabel(this.notfoundMsg));
                    stringBuilder.append(HybsSystem.BR);
                }
            }
            this.setRequestAttribute("DB.COUNT", String.valueOf(this.executeCount));
            this.setRequestAttribute("DB.ERR_CODE", String.valueOf(this.errCode));
            if (this.table != null && this.table.isOverflow() && this.overflowMsg != null && this.overflowMsg.length() > 0) {
                stringBuilder.append(this.getResource().getLabel(this.overflowMsg));
                stringBuilder.append(HybsSystem.BR);
            }
            if ((string2 = TaglibUtil.makeHTMLErrorTable(this.errMessage, this.getResource())) != null && string2.length() > 0) {
                stringBuilder.append(string2);
                this.setSessionAttribute(errMsgId, this.errMessage);
            } else if (CMD_NEW.equals(this.command)) {
                this.removeSessionAttribute(errMsgId);
            }
            string = stringBuilder.toString();
            if (this.table != null && !this.commitTableObject(this.tableId, this.table)) {
                ErrorMessage errorMessage = new ErrorMessage("QueryTag Query Error!");
                errorMessage.addMessage(0, 2, "ERR0041", new String[0]);
                this.jspPrint(TaglibUtil.makeHTMLErrorTable(errorMessage, this.getResource()));
                return 5;
            }
        }
        this.jspPrint(string);
        int n = this.errCode >= 2 ? (this.stopError ? 5 : 6) : (this.executeCount == 0 && this.stopZero ? 5 : 6);
        long l = System.currentTimeMillis() - this.dyStart;
        if (this.useBeforeHtmlTag) {
            this.jspPrint("<div id=\"queryTime\" value=\"" + l + "\"></div>");
        }
        if ((gUIInfo = (GUIInfo)this.getSessionAttribute("h_gInfo")) != null) {
            gUIInfo.addReadCount(this.executeCount, l, this.sql);
        }
        return n;
    }

    @Override
    protected void release2() {
        super.release2();
        this.tableId = "h_tblmdl";
        this.queryType = null;
        this.dbid = null;
        this.command = CMD_NEW;
        this.skipRowCount = 0;
        this.maxRowCount = -1;
        this.table = null;
        this.sql = null;
        this.displayMsg = HybsSystem.sys("VIEW_DISPLAY_MSG");
        this.overflowMsg = "MSG0007";
        this.notfoundMsg = "MSG0077";
        this.executeCount = -1;
        this.names = null;
        this.outMessage = true;
        this.trace = false;
        this.errCode = 0;
        this.errMessage = null;
        this.stopZero = false;
        this.stopError = true;
        this.dyStart = 0L;
        this.debugMsg = null;
        this.checkNames = null;
        this.quotCheck = HybsSystem.sysBool("USE_SQL_INJECTION_CHECK");
        this.modifyType = null;
        this.traceMsg = null;
        this.xssCheck = HybsSystem.sysBool("USE_XSS_CHECK");
        this.isMainTrans = true;
        this.useBeforeHtmlTag = true;
    }

    protected void execute(Query query) {
        String[] stringArray = null;
        String[] stringArray2 = null;
        try {
            if (this.names == null || this.names.length() == 0) {
                query.execute();
            } else {
                stringArray = StringUtil.csv2Array((String)this.names);
                stringArray2 = this.getRequest(stringArray);
                if (this.isDebug()) {
                    this.printDebug(stringArray, stringArray2);
                }
                query.execute(stringArray2);
            }
            this.errCode = query.getErrorCode();
            this.errMessage = query.getErrorMessage();
            if (query.isUpdate()) {
                if (this.errCode < 2) {
                    query.commit();
                } else {
                    query.rollback();
                }
            }
        }
        catch (HybsSystemException hybsSystemException) {
            query.rollback();
            String string = "DATABASE ERROR! " + HybsSystem.CR;
            if (stringArray != null) {
                this.printDebug(stringArray, stringArray2);
                string = string + this.debugMsg;
            }
            throw new HybsSystemException(string, hybsSystemException);
        }
        finally {
            if (query != null) {
                query.close();
            }
        }
    }

    private void printDebug(String[] stringArray, String[] stringArray2) {
        if (this.debugMsg == null) {
            this.debugMsg = new StringBuilder();
        }
        this.debugMsg.append("  names=[");
        this.debugMsg.append(StringUtil.array2csv((String[])stringArray));
        this.debugMsg.append("]");
        this.debugMsg.append(HybsSystem.CR);
        this.debugMsg.append("  values=[");
        this.debugMsg.append(StringUtil.array2csv((String[])stringArray2));
        this.debugMsg.append("]");
        this.debugMsg.append(HybsSystem.CR);
    }

    protected String[] getRequest(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            DBColumn dBColumn;
            String string;
            stringArray2[i] = this.getRequestValue(stringArray[i]);
            if (this.checkNames == null || this.checkNames.length() <= 0 || stringArray2[i].length() <= 0 || ("," + this.checkNames + ",").indexOf("," + stringArray[i] + ",") < 0 || (string = (dBColumn = this.getDBColumn(stringArray[i])).valueSet(stringArray2[i])) == null) continue;
            stringArray2[i] = string;
        }
        return stringArray2;
    }

    public void setSkipRowCount(String string) {
        this.skipRowCount = StringUtil.nval((String)this.getRequestParameter(string), (int)this.skipRowCount);
    }

    public void setMaxRowCount(String string) {
        this.maxRowCount = StringUtil.nval((String)this.getRequestParameter(string), (int)this.maxRowCount);
        if (this.maxRowCount == 0) {
            this.maxRowCount = Integer.MAX_VALUE;
        }
    }

    public void setTableId(String string) {
        this.tableId = StringUtil.nval((String)this.getRequestParameter(string), (String)this.tableId);
    }

    public void setQueryType(String string) {
        this.queryType = this.getRequestParameter(string);
    }

    public void setDbid(String string) {
        this.dbid = StringUtil.nval((String)this.getRequestParameter(string), (String)this.dbid);
    }

    public void setCommand(String string) {
        String string2 = this.getRequestParameter(string);
        if (string2 != null && string2.length() >= 0) {
            this.command = string2.toUpperCase(Locale.JAPAN);
        }
    }

    public void setStopZero(String string) {
        this.stopZero = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.stopZero);
    }

    public void setDisplayMsg(String string) {
        String string2 = this.getRequestParameter(string);
        if (string2 != null) {
            this.displayMsg = string2;
        }
    }

    public void setOverflowMsg(String string) {
        String string2 = this.getRequestParameter(string);
        if (string2 != null) {
            this.overflowMsg = string2;
        }
    }

    public void setNotfoundMsg(String string) {
        String string2 = this.getRequestParameter(string);
        if (string2 != null) {
            this.notfoundMsg = string2;
        }
    }

    public void setNames(String string) {
        this.names = StringUtil.nval((String)this.getRequestParameter(string), (String)this.names);
    }

    public void setOutMessage(String string) {
        this.outMessage = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.outMessage);
    }

    public void setTrace(String string) {
        this.trace = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.trace);
    }

    public void setCheckNames(String string) {
        this.checkNames = StringUtil.nval((String)this.getRequestParameter(string), (String)this.checkNames);
    }

    public void setModifyType(String string) {
        this.modifyType = StringUtil.nval((String)this.getRequestParameter(string), (String)this.modifyType);
    }

    public void setQuotCheck(String string) {
        this.quotCheck = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.quotCheck);
    }

    public void setXssCheck(String string) {
        this.xssCheck = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.xssCheck);
    }

    public void setStopError(String string) {
        this.stopError = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.stopError);
    }

    private String traceQuery(String string, Transaction transaction) {
        int n;
        String string2 = this.getUserInfo("ID");
        String[] stringArray = new String[]{string2};
        DBUtil.dbExecute((String)"DELETE FROM PLAN_TABLE WHERE STATEMENT_ID = ?", (String[])stringArray, (Transaction)transaction, (String)this.dbid);
        String string3 = "EXPLAIN PLAN SET STATEMENT_ID = '" + string2 + "' FOR " + string;
        DBUtil.dbExecute((String)string3, null, (Transaction)transaction, (String)this.dbid);
        String[] stringArray2 = new String[]{string2, string2, string2};
        String string4 = "select LEVEL as LVL,lpad(' ',LEVEL,' ') || rtrim( OPERATION ) || ' ' || rtrim( OPTIONS ) || ' ' || rtrim( OBJECT_NAME ) as EXECUTION_PLAN,OBJECT_NAME\t\t\tas OBJ_NAME,DECODE(INSTR(OBJECT_TYPE,' '),0,OBJECT_TYPE,SUBSTR(OBJECT_TYPE,1,INSTR(OBJECT_TYPE,' ')-1)) as OBJ_TYPE,OPTIMIZER\t\t\tas OPT,COST\t\t\t\tas CST,CARDINALITY\t\t\tas CARD,BYTES\t\t\t\tas BYTE,ACCESS_PREDICATES\tas ACCS,FILTER_PREDICATES\tas FILTER from PLAN_TABLE where STATEMENT_ID = ? start with ID = 0 \t  and STATEMENT_ID = ? connect by prior ID = PARENT_ID \t  and STATEMENT_ID = ?";
        String[][] stringArray3 = DBUtil.dbExecute((String)string4, (String[])stringArray2, (Transaction)transaction, (String)this.dbid, (boolean)true);
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append("<pre>").append(string).append("</pre>").append(HybsSystem.BR);
        stringBuilder.append("<table>");
        int n2 = stringArray3[0].length;
        stringBuilder.append("<tr class=\"row_h\">");
        for (n = 0; n < n2; ++n) {
            stringBuilder.append("<th>").append(stringArray3[0][n]).append("</th>");
        }
        stringBuilder.append("</tr>");
        for (n = 1; n < stringArray3.length; ++n) {
            stringBuilder.append("<tr class=\"row_").append(n % 2).append("\">");
            for (int i = 0; i < n2; ++i) {
                if (i == 1) {
                    stringBuilder.append("<td><pre>").append(stringArray3[n][1]).append("</pre></td>");
                    continue;
                }
                stringBuilder.append("<td>").append(stringArray3[n][i]).append("</td>");
            }
            stringBuilder.append("</tr>");
        }
        stringBuilder.append("</table>").append(HybsSystem.BR);
        return stringBuilder.toString();
    }

    public void setMainTrans(String string) {
        this.isMainTrans = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.isMainTrans);
    }

    public void setUseBeforeHtmlTag(String string) {
        this.useBeforeHtmlTag = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useBeforeHtmlTag);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    @Override
    public String toString() {
        return this.sql;
    }
}

