<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "24_ERRMSG"
	title	= "ｴﾗｰﾒｯｾｰｼﾞ編集"
	date	= "2012/04/10"
	author	= "Son.I"
	text	= ""
	version	= "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 入力チェック -->
<!-- nullCheckの記述は不要です。columnのチェックを行う場合は、個別に記述する必要があります -->
<og:columnCheck command = "{@command}" />

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<!-- <jsp:text>は不要です-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
		SELECT	 A.CLM
				,A.NAME_JA
				,A.LNAME
				,A.SNAME
				,A.DESCRIPTION
				,A.COMMENTS
				,A.KBSAKU
				,A.KBLBL
				,A.FGLOAD
				,A.SYSTEM_ID
				,A.LANG
				,A.RDC_CODE
				,A.RELEASE_NOTES
				,A.DYUPD
				,A.CDKH
				,A.FGJ
				,A.UNIQ
		from GEA08 A
		<og:where>
			<og:and value = "A.SYSTEM_ID	=		'{@SYSTEM_ID}'"		 />	<!-- ｼｽﾃﾑID			-->
			<og:and value = "A.FGJ			=		'1'"			 />	<!-- 状態F			-->
			<og:and value = "A.LANG		=		'{@LANG}'"				 />	<!-- 言語			-->
			<og:and value = "UPPER(CLM)	like	UPPER('{@CLM}%')"		 />	<!-- ｶﾗﾑ名			-->
			<og:and value = "A.NAME_JA		like	'%{@NAME_JA}%'"		 />	<!-- 名称(漢字)		-->
			<og:and value = "A.LNAME		like	'%{@LNAME}%'"		 />	<!-- 名前(長)		-->
			<og:and value = "A.SNAME		like	'%{@SNAME}%'"		 />	<!-- 名前(短)		-->
			<og:and value = "A.DESCRIPTION	like	'%{@DESCRIPTION}%'"	 />	<!-- 概要説明		-->
			<og:and value = "A.KBLBL		=		'8'"			 />	<!-- ﾗﾍﾞﾙ区分 ERR		-->
			<og:and value = "A.DYUPD	&gt;=		'{@DYUPDFROM}'"		 />	<!-- 更新日(FROM)	-->
			<og:and value = "A.DYUPD	&lt;=		'{@DYUPDTO}99'"		 />	<!-- 更新日(TO)		-->
			<og:and value = "A.COMMENTS	like	'%{@COMMENTS}%'"						 />	<!-- 改廃ｺｰﾄﾞ		-->
		</og:where>
		<og:appear startKey = "order by" value = "{@ORDER_BY}"
					defaultVal = "A.CLM,A.SYSTEM_ID DESC,A.KBSAKU DESC" />
</og:query>


<!-- formタグでリクエストフィールドを囲います。oneClick()関数は、２重押し防止JavaScriptです。 -->
<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">

<!-- 複写、変更、削除ボタンを作成します。value属性+.jspの画面に制御が移ります。 -->
<!-- このとき、command=(value属性の値の大文字)が設定されます。 command属性で設定しなおすことも出来ます。-->
<!-- ここでは、すべてを、update.jsp に転送している為、command属性を設定しています。-->
<og:writeCheck>
	<og:submit value="update" command="MODIFY" lbl="MODIFY" accesskey="M" 
			keys="noWritable" vals='"SYSTEM_ID,LANG,CLM,UNIQ"' />
<br />
</og:writeCheck>

<!-- DB検索結果を表示させます。 -->
<!-- checked="true" で、チェック済みの状態で表示できます。 -->
<!-- selectedType="checkbox(デフォルト)/radio/hidden" から、選べます。-->
<!-- サンプルではポップアップを使用するためviewFormTypeはHTMLCustomTableを使用します-->
<og:view
	viewFormType = "HTMLTable"
	command		= "{@command}"
	noDisplay	= "UNIQ,SNAME,FGLOAD,SYSTEM_ID,LANG,RDC_CODE,RELEASE_NOTES,DYUPD,CDKH,FGJ,KBSAKU,KBLBL"
/>

</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
