/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.taglet;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.Tag;
import com.sun.javadoc.Type;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.opengion.fukurou.taglet.AttKeySet;
import org.opengion.fukurou.taglet.DocletTagWriter;
import org.opengion.fukurou.taglet.DocletUtil;
import org.opengion.fukurou.util.LogWriter;

public final class DocletPlugin {
    private static Map<String, AttKeySet> map = new HashMap<String, AttKeySet>();
    private static final String OG_FOR_SMPL = "og.formSample";
    private static final String ENCODE = "UTF-8";

    private DocletPlugin() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean start(RootDoc rootDoc) {
        String string = DocletUtil.getOption("-version", rootDoc.options());
        String string2 = DocletUtil.getOption("-outfile", rootDoc.options());
        DocletPlugin.mapInit();
        DocletTagWriter docletTagWriter = null;
        try {
            docletTagWriter = new DocletTagWriter(string2, ENCODE);
            docletTagWriter.printTag("<?xml version=\"1.0\" encoding=\"", ENCODE, "\" ?>");
            docletTagWriter.printTag("<javadoc>");
            docletTagWriter.printTag("  <version>", string, "</version>");
            docletTagWriter.printTag("  <description></description>");
            DocletPlugin.writeContents(rootDoc.classes(), docletTagWriter);
            docletTagWriter.printTag("</javadoc>");
        }
        catch (IOException iOException) {
            LogWriter.log(iOException);
        }
        finally {
            if (docletTagWriter != null) {
                docletTagWriter.close();
            }
        }
        return true;
    }

    private static void writeContents(ClassDoc[] classDocArray, DocletTagWriter docletTagWriter) {
        for (int i = 0; i < classDocArray.length; ++i) {
            String string;
            AttKeySet attKeySet;
            ClassDoc classDoc = classDocArray[i];
            if (!classDoc.isPublic() || (attKeySet = DocletPlugin.getAttGroupName(classDoc)) == null || (string = attKeySet.getAttKey(classDoc.name())) == null) continue;
            String string2 = classDoc.qualifiedName();
            Tag[] tagArray = classDoc.firstSentenceTags();
            Tag[] tagArray2 = classDoc.inlineTags();
            Tag[] tagArray3 = classDoc.tags(OG_FOR_SMPL);
            docletTagWriter.printTag("<classDoc>");
            docletTagWriter.printTag("  <attClass>", string2, "</attClass>");
            docletTagWriter.printTag("  <seq>", attKeySet.getSeq(), "</seq>");
            docletTagWriter.printTag("  <attKey>", string, "</attKey>");
            docletTagWriter.printTag("  <valueName>", attKeySet.getValueName(), "</valueName>");
            docletTagWriter.printTag("  <description>", tagArray, "</description>");
            docletTagWriter.printTag("  <contents>", tagArray2, "</contents>");
            docletTagWriter.printTag("  <formSample>", tagArray3, "</formSample>");
            docletTagWriter.printTag("</classDoc>");
        }
    }

    private static void mapInit() {
        map.put("org.opengion.hayabusa.db.Query", new AttKeySet("Query", 0, "queryType"));
        map.put("org.opengion.hayabusa.db.CellRenderer", new AttKeySet("Renderer", 1, "renderer"));
        map.put("org.opengion.hayabusa.db.CellEditor", new AttKeySet("Editor", 2, "editor"));
        map.put("org.opengion.hayabusa.db.DBType", new AttKeySet("DBType", 3, "dbType"));
        map.put("org.opengion.hayabusa.db.TableFilter", new AttKeySet("TableFilter", 4, "tableFilter"));
        map.put("org.opengion.hayabusa.db.Selection", new AttKeySet("Selection", 5, "selection"));
        map.put("org.opengion.hayabusa.html.ViewForm", new AttKeySet("ViewForm", 6, "viewFormType"));
        map.put("org.opengion.hayabusa.io.TableWriter", new AttKeySet("TableWriter", 7, "writerClass"));
        map.put("org.opengion.hayabusa.io.TableReader", new AttKeySet("TableReader", 8, "readerClass"));
        map.put("org.opengion.hayabusa.resource.CalendarQuery", new AttKeySet("CalendarQuery", 10, "calDB"));
        map.put("org.opengion.fukurou.process.HybsProcess", new AttKeySet("Process", 11, "process"));
        map.put("org.opengion.fukurou.transfer.TransferExec", new AttKeySet("TransferExec", 12, "kbExec"));
        map.put("org.opengion.fukurou.transfer.TransferRead", new AttKeySet("TransferRead", 13, "kbRead"));
        map.put("org.opengion.fukurou.util.HybsTimerTask", new AttKeySet("Daemon", 14, "daemon"));
        map.put("org.opengion.hayabusa.report.DBTableReport", new AttKeySet("DBTableReport", 15, "tableReport"));
        map.put("org.opengion.hayabusa.resource.CalendarData", new AttKeySet("CalendarData", 16, "calData"));
        map.put("org.opengion.hayabusa.db.DBConstValue", new AttKeySet("DBConstValue", 17, "cnstVal"));
        map.put("org.opengion.fukurou.xml.JspParserFilter", new AttKeySet("JspCreate", 18, "jspParser"));
        map.put("org.opengion.fukurou.util.ConnectIF\t", new AttKeySet("ConnectIF", 19, "connIF"));
    }

    private static AttKeySet getAttGroupName(ClassDoc classDoc) {
        if (classDoc == null) {
            return null;
        }
        String string = classDoc.qualifiedName();
        AttKeySet attKeySet = map.get(string);
        if (attKeySet == null) {
            Type type = classDoc.superclassType();
            if (type != null) {
                attKeySet = DocletPlugin.getAttGroupName(type.asClassDoc());
            }
            if (attKeySet == null) {
                Type[] typeArray = classDoc.interfaceTypes();
                for (int i = 0; i < typeArray.length && (attKeySet = DocletPlugin.getAttGroupName(typeArray[i].asClassDoc())) == null; ++i) {
                }
            }
        }
        return attKeySet;
    }

    public static int optionLength(String string) {
        if (string.equalsIgnoreCase("-version")) {
            return 2;
        }
        if (string.equalsIgnoreCase("-outfile")) {
            return 2;
        }
        return 0;
    }
}

