/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.common;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.xml.HybsXMLSave;
import org.opengion.hayabusa.common.HybsSystem;

public final class InitFileLoader {
    private final String CLASSPATH;
    private final Connection connection;
    private boolean fileCommit = false;

    public InitFileLoader(Connection connection) {
        this(connection, "resource");
    }

    public InitFileLoader(Connection connection, String string) {
        this.connection = connection;
        this.CLASSPATH = string;
    }

    public void setFileCommit(boolean bl) {
        this.fileCommit = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadInitFiles(boolean bl) {
        ArrayList<File> arrayList = new ArrayList<File>();
        JarFile jarFile = null;
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Enumeration<URL> enumeration = classLoader.getResources(this.CLASSPATH);
            while (enumeration.hasMoreElements()) {
                Object object;
                String string;
                block12: {
                    URL uRL = enumeration.nextElement();
                    string = uRL.getFile();
                    if (!"jar".equals(uRL.getProtocol())) break block12;
                    object = string.substring(string.indexOf(58) + 1, string.lastIndexOf(33));
                    jarFile = new JarFile((String)object);
                    Enumeration<JarEntry> enumeration2 = jarFile.entries();
                    while (enumeration2.hasMoreElements()) {
                        JarEntry jarEntry = enumeration2.nextElement();
                        String string2 = jarEntry.getName();
                        if (jarEntry.isDirectory() || !string2.endsWith(".xml") || bl && jarEntry.getTime() <= 0L) continue;
                        String string3 = string2.substring(string2.lastIndexOf(47) + 1, string2.lastIndexOf(46));
                        InputStream inputStream = null;
                        try {
                            System.out.println("      " + uRL + string2);
                            inputStream = jarFile.getInputStream(jarEntry);
                            this.loadXML(inputStream, this.connection, string3);
                        }
                        catch (Throwable throwable) {
                            Closer.ioClose(inputStream);
                            throw throwable;
                        }
                        Closer.ioClose((Closeable)inputStream);
                        if (!this.fileCommit) continue;
                        this.connection.commit();
                    }
                    Closer.zipClose((ZipFile)jarFile);
                    jarFile = null;
                    continue;
                }
                object = new File(string);
                this.loadXMLDir((File)object, bl, arrayList);
            }
            this.connection.commit();
        }
        catch (SQLException sQLException) {
            String string = "SQL\u5b9f\u884c\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + HybsSystem.CR + sQLException.getMessage();
            Closer.rollback((Connection)this.connection);
            throw new RuntimeException(string, sQLException);
        }
        catch (IOException iOException) {
            String string = "XML\u30d5\u30a1\u30a4\u30eb\u8aad\u307f\u53d6\u308a\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + HybsSystem.CR + iOException.getMessage();
            throw new RuntimeException(string, iOException);
        }
        finally {
            Closer.zipClose(jarFile);
            for (File file : arrayList) {
                if (file.setLastModified(0L)) continue;
                String string = "\u30bf\u30a4\u30e0\u30b9\u30bf\u30f3\u30d7\u306e\u66f8\u304d\u63db\u3048\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002file=" + file;
                System.out.println(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadXMLDir(File file, boolean bl, List<File> list) throws SQLException, IOException {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            block4: {
                String string = fileArray[i].getName();
                if (!fileArray[i].isFile() || !string.endsWith(".xml")) break block4;
                if (bl && fileArray[i].lastModified() <= 0L) continue;
                String string2 = string.substring(string.lastIndexOf(47) + 1, string.lastIndexOf(46));
                FileInputStream fileInputStream = null;
                try {
                    System.out.println("      " + fileArray[i]);
                    fileInputStream = new FileInputStream(fileArray[i]);
                    this.loadXML(fileInputStream, this.connection, string2);
                }
                catch (Throwable throwable) {
                    Closer.ioClose(fileInputStream);
                    throw throwable;
                }
                Closer.ioClose((Closeable)fileInputStream);
                if (this.fileCommit) {
                    this.connection.commit();
                }
                list.add(fileArray[i]);
                continue;
            }
            this.loadXMLDir(fileArray[i], bl, list);
        }
    }

    private int loadXML(InputStream inputStream, Connection connection, String string) throws SQLException, UnsupportedEncodingException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        HybsXMLSave hybsXMLSave = new HybsXMLSave(connection, string);
        hybsXMLSave.insertXML((Reader)bufferedReader);
        int n = hybsXMLSave.getInsertCount();
        int n2 = hybsXMLSave.getDeleteCount();
        String string2 = hybsXMLSave.getTableName();
        System.out.println("        TABLE=[" + string2 + "]  DELETE=[" + n2 + "] INSERT=[" + n + "]");
        return n;
    }
}

