<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GE:エンジン"
	pgid	= "MAIL01"
	title	= "定型文マスタ管理"
	date	= "2009/04/01"
	author	= "S.Li"
	text	= ""
	version	= "001"
/>

<og:equals val1="{@SYS.VER4_COMPATIBLE_MODE}" val2="true">
	<og:value command="SET" key="C_CONTENTS" value="CONTENT" />
</og:equals>
<og:equals val1="{@SYS.VER4_COMPATIBLE_MODE}" val2="true" notEquals="true">
	<og:value command="SET" key="C_CONTENTS" value="CONTENTS" />
</og:equals>

<!-- forward.jsp から command = "COPY/MODIFY/DELETE" がセットされて遷移してきます。-->
<!-- データが選ばれていなければエラー -->
<og:columnCheck command="{@command}" >
	<jsp:directive.include file="/jsp/common/history_back.jsp" />
</og:columnCheck>

<!-- entryタグのcommandとcolumnSetのコマンドが同じ場合のみ、動作します。 -->
<og:entry command="{@command}" />
<og:message command="{@command}" /><br />

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">

<!-- 登録、取消、リセットボタンを作成します。 -->
<og:writeCheck>
	<og:submit  value="entry"   lbl="ENTRY" accesskey="E" />
	<og:submit  value="reset"   lbl="RESET" accesskey="R" />
	<og:input   type="reset"  name="command"  lbl="MSG0011"  td="false" />
	<br />
</og:writeCheck>
<og:columnEditor column="SYSTEM_ID" must="true" />
<!-- DB検索結果を表示させます。 -->
<og:view
	viewFormType = "HTMLFormatTextField" 
	command      = "{@command}" 
	noDisplay    = "UNIQ,PUP" 
	noWritable   = "UNIQ"
	noMessage	 = "true"
	skip         = "true"
>
	<table summary="layout">
		<tr>[SYSTEM_ID]</tr>
		<tr>[PTN_ID]</tr>
		<tr>[FROM_ID]</tr>
		<tr>[TO_ID]</tr>
		<tr>[CC_ID]</tr>
		<tr>[BCC_ID]</tr>
		<tr>[MAIL_TITLE]</tr>
		<tr>[CONTENTS]</tr>
	</table>
</og:view>

<og:hidden name="SQL" >
  <jsp:text>
	INSERT INTO GE31(SYSTEM_ID
					,PTN_ID
					,FROM_ID
					,TO_ID
					,CC_ID
					,BCC_ID
					,TITLE
					,{@C_CONTENTS}
					,DYSET
					,USRSET
					,PGUPD )
			VALUES(  [SYSTEM_ID]
					,[PTN_ID]
					,[FROM_ID]
					,[TO_ID]
					,[CC_ID]
					,[BCC_ID]
					,[MAIL_TITLE]
					,[CONTENTS]
					,'{@DATE.YMDHMS}'
					,'{@USER.ID}'
					,'{@GUI.KEY}' )
  </jsp:text>
</og:hidden>

</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
