/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspWriter;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.HybsEntry;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.io.TableWriter;
import org.opengion.hayabusa.taglib.CommonTagSupport;

public class WriteTableTag
extends CommonTagSupport {
    private static final String VERSION = "4.0.0 (2005/08/31)";
    private static final long serialVersionUID = 4000L;
    private final String BASE_URL = HybsSystem.sys("FILE_URL");
    private String separator = "\t";
    private String headerSequence = null;
    private String fileURL = this.BASE_URL;
    private String filename = HybsSystem.sys("FILE_FILENAME");
    private String refFileURL = this.BASE_URL;
    private String refFilename = null;
    private String fontName = HybsSystem.sys("TABLE_WRITER_DEFAULT_FONT_NAME");
    private String fontPoint = HybsSystem.sys("TABLE_WRITER_DEFAULT_FONT_POINTS");
    private String encode = HybsSystem.sys("FILE_ENCODE");
    private String writerClass = HybsSystem.sys("TABLE_WRITER_DEFAULT_CLASS");
    private boolean fileAppend = false;
    private boolean direct = false;
    private boolean zip = false;
    private String disposition = "attachment";
    private transient DBTableModel table = null;
    private String tableId = "h_tblmdl";
    private String sheetName = "Sheet1";
    private String refSheetName = null;
    private String directory = null;
    private transient List<HybsEntry> param = null;
    private boolean useNumber = true;
    private String columns = null;
    private boolean useRenderer = HybsSystem.sysBool("USE_TABLE_WRITER_RENDERER");
    private boolean selectedAll = true;
    private boolean beforeDelete = false;

    @Override
    public int doStartTag() {
        this.directory = HybsSystem.url2dir(this.fileURL);
        if (this.beforeDelete && !this.fileAppend) {
            File file = null;
            file = this.zip ? new File(this.directory, this.filename + ".zip") : new File(this.directory, this.filename);
            if (file.exists()) {
                file.delete();
            }
        }
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int doEndTag() {
        this.debugPrint();
        this.table = (DBTableModel)this.getObject(this.tableId);
        if (!this.selectedAll) {
            this.table = this.getSelRowsTable(this.table);
        }
        if (this.table != null && this.table.getRowCount() > 0) {
            ByteArrayOutputStream byteArrayOutputStream;
            PrintWriter printWriter;
            block14: {
                File file = new File(this.directory);
                if (!file.exists() && !file.mkdirs()) {
                    String string = "\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002[" + this.directory + "]";
                    throw new HybsSystemException(string);
                }
                printWriter = null;
                byteArrayOutputStream = null;
                try {
                    if (this.direct) {
                        if (this.zip) {
                            byteArrayOutputStream = new ByteArrayOutputStream();
                            printWriter = new PrintWriter(byteArrayOutputStream);
                            this.create(printWriter);
                            printWriter.flush();
                            ServletResponse servletResponse = this.pageContext.getResponse();
                            ((HttpServletResponse)servletResponse).addHeader("Content-Encoding", "gzip");
                            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
                            gZIPOutputStream.finish();
                            servletResponse.setContentLength(byteArrayOutputStream.size());
                            JspWriter jspWriter = this.pageContext.getOut();
                            jspWriter.clear();
                            jspWriter.print((Object)byteArrayOutputStream);
                            jspWriter.flush();
                        } else {
                            byteArrayOutputStream = new ByteArrayOutputStream();
                            printWriter = new PrintWriter(byteArrayOutputStream);
                            this.create(printWriter);
                            printWriter.flush();
                            ServletResponse servletResponse = this.pageContext.getResponse();
                            servletResponse.setContentType("application/vnd.ms-excel; charset=" + this.encode);
                            ((HttpServletResponse)servletResponse).setHeader("Content-Disposition", this.disposition + "; filename=\"" + this.filename + "\"");
                            JspWriter jspWriter = this.pageContext.getOut();
                            jspWriter.clear();
                            jspWriter.print((Object)byteArrayOutputStream);
                            jspWriter.flush();
                        }
                        break block14;
                    }
                    if (this.zip) {
                        byteArrayOutputStream = new ByteArrayOutputStream();
                        printWriter = this.writerClass.toUpperCase(Locale.JAPAN).startsWith("EXCEL") || this.writerClass.toUpperCase(Locale.JAPAN).startsWith("CALC") ? new PrintWriter(byteArrayOutputStream) : this.getPrintWriter(byteArrayOutputStream);
                        this.create(printWriter);
                        printWriter.flush();
                        ZipOutputStream zipOutputStream = null;
                        try {
                            zipOutputStream = new ZipOutputStream(new FileOutputStream(StringUtil.urlAppend((String)this.directory, (String)(this.filename + ".zip"))));
                            zipOutputStream.putNextEntry(new ZipEntry(this.filename));
                            byteArrayOutputStream.writeTo(zipOutputStream);
                            zipOutputStream.finish();
                        }
                        catch (Throwable throwable) {
                            Closer.ioClose(zipOutputStream);
                            throw throwable;
                        }
                        Closer.ioClose((Closeable)zipOutputStream);
                        break block14;
                    }
                    if (this.writerClass.toUpperCase(Locale.JAPAN).startsWith("EXCEL") || this.writerClass.toUpperCase(Locale.JAPAN).startsWith("CALC")) {
                        this.create(null);
                        break block14;
                    }
                    printWriter = this.getPrintWriter();
                    this.create(printWriter);
                    printWriter.flush();
                }
                catch (IOException iOException) {
                    try {
                        String string = "\u30c6\u30fc\u30d6\u30eb\u51fa\u529b\u6642\u306b\u3001IO\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + this.toString();
                        throw new HybsSystemException(string, iOException);
                    }
                    catch (Throwable throwable) {
                        Closer.ioClose(printWriter);
                        Closer.ioClose(byteArrayOutputStream);
                        throw throwable;
                    }
                }
            }
            Closer.ioClose((Closeable)printWriter);
            Closer.ioClose((Closeable)byteArrayOutputStream);
        }
        return 6;
    }

    @Override
    protected void release2() {
        super.release2();
        this.separator = "\t";
        this.headerSequence = null;
        this.fileURL = this.BASE_URL;
        this.filename = HybsSystem.sys("FILE_FILENAME");
        this.beforeDelete = false;
        this.refFileURL = this.BASE_URL;
        this.refFilename = null;
        this.fontName = HybsSystem.sys("TABLE_WRITER_DEFAULT_FONT_NAME");
        this.fontPoint = HybsSystem.sys("TABLE_WRITER_DEFAULT_FONT_POINTS");
        this.encode = HybsSystem.sys("FILE_ENCODE");
        this.writerClass = HybsSystem.sys("TABLE_WRITER_DEFAULT_CLASS");
        this.fileAppend = false;
        this.direct = false;
        this.zip = false;
        this.table = null;
        this.tableId = "h_tblmdl";
        this.disposition = "attachment";
        this.sheetName = "Sheet1";
        this.refSheetName = null;
        this.param = null;
        this.useNumber = true;
        this.directory = null;
        this.columns = null;
        this.useRenderer = HybsSystem.sysBool("USE_TABLE_WRITER_RENDERER");
        this.selectedAll = true;
    }

    private void create(PrintWriter printWriter) {
        if ("ExcelRenderer".equalsIgnoreCase(this.writerClass)) {
            this.writerClass = "Excel";
            this.useRenderer = true;
        } else if ("Renderer".equalsIgnoreCase(this.writerClass)) {
            this.writerClass = "Default";
            this.useRenderer = true;
        }
        String string = HybsSystem.sys("TableWriter_" + this.writerClass);
        TableWriter tableWriter = (TableWriter)HybsSystem.newInstance(string);
        tableWriter.setDBTableModel(this.table, this.getLanguage());
        tableWriter.setSeparator(this.separator);
        tableWriter.setHeaderSequence(this.headerSequence);
        tableWriter.setEncode(this.encode);
        tableWriter.setAppend(this.fileAppend);
        if (this.param != null) {
            tableWriter.setParam(this.param);
        }
        tableWriter.setUseNumber(this.useNumber);
        tableWriter.setColumns(this.columns);
        tableWriter.setUseRenderer(this.useRenderer);
        if (tableWriter.isExcel()) {
            tableWriter.setSheetName(this.sheetName);
            tableWriter.setFilename(StringUtil.urlAppend((String)this.directory, (String)this.filename));
            if (this.refFileURL != null && this.refFilename != null) {
                tableWriter.setRefFilename(StringUtil.urlAppend((String)HybsSystem.url2dir(this.refFileURL), (String)this.refFilename));
            }
            tableWriter.setRefSheetName(this.refSheetName);
            tableWriter.setFontName(StringUtil.nval((String)this.fontName, null));
            if (this.fontPoint != null && this.fontPoint.length() > 0) {
                tableWriter.setFontPoint(Short.parseShort(this.fontPoint));
            }
            tableWriter.writeDBTable();
        } else {
            tableWriter.writeDBTable(printWriter);
        }
    }

    private PrintWriter getPrintWriter() {
        if (this.filename == null) {
            String string = "\u30d5\u30a1\u30a4\u30eb\u540d\u304c\u30bb\u30c3\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
            throw new HybsSystemException(string);
        }
        PrintWriter printWriter = FileUtil.getPrintWriter((File)new File(this.directory, this.filename), (String)this.encode, (boolean)this.fileAppend);
        return printWriter;
    }

    private PrintWriter getPrintWriter(OutputStream outputStream) {
        PrintWriter printWriter = FileUtil.getPrintWriter((OutputStream)outputStream, (String)this.encode);
        return printWriter;
    }

    private DBTableModel getSelRowsTable(DBTableModel dBTableModel) {
        if (dBTableModel == null) {
            return null;
        }
        DBTableModel dBTableModel2 = dBTableModel.newModel();
        int[] nArray = this.getParameterRows();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            dBTableModel2.addValues((String[])dBTableModel.getValues(nArray[i]), i);
        }
        return dBTableModel2;
    }

    public void setTableId(String string) {
        this.tableId = StringUtil.nval((String)this.getRequestParameter(string), (String)this.tableId);
    }

    public void setSeparator(String string) {
        this.separator = StringUtil.nval((String)this.getRequestParameter(string), (String)this.separator);
    }

    public void setHeaderSequence(String string) {
        String[] stringArray = this.getRequestParameterValues(string);
        if (stringArray != null) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null) continue;
                stringBuilder.append(stringArray[i]);
            }
            this.headerSequence = stringBuilder.toString();
        }
    }

    public void setRefFileURL(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string2 != null) {
            char c = string2.charAt(string2.length() - 1);
            if (c != '/' && c != '\\') {
                string2 = string2 + "/";
            }
            this.refFileURL = StringUtil.urlAppend((String)this.refFileURL, (String)string2);
        }
    }

    public void setFileURL(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string2 != null) {
            char c = string2.charAt(string2.length() - 1);
            if (c != '/' && c != '\\') {
                string2 = string2 + "/";
            }
            this.fileURL = StringUtil.urlAppend((String)this.fileURL, (String)string2);
        }
    }

    public void setFilename(String string) {
        this.filename = StringUtil.nval((String)this.getRequestParameter(string), (String)this.filename);
    }

    public void setRefFilename(String string) {
        this.refFilename = StringUtil.nval((String)this.getRequestParameter(string), (String)this.refFilename);
    }

    public void setEncode(String string) {
        this.encode = StringUtil.nval((String)this.getRequestParameter(string), (String)this.encode);
    }

    public void setWriterClass(String string) {
        this.writerClass = StringUtil.nval((String)this.getRequestParameter(string), (String)this.writerClass);
    }

    public void setFileAppend(String string) {
        this.fileAppend = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.fileAppend);
    }

    @Deprecated
    public void setDirect(String string) {
        this.direct = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.direct);
    }

    public void setZip(String string) {
        this.zip = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.zip);
    }

    public void setDisposition(String string) {
        this.disposition = StringUtil.nval((String)this.getRequestParameter(string), (String)this.disposition);
        if (!"inline".equals(this.disposition) && !"attachment".equals(this.disposition)) {
            String string2 = "disposition \u306b\u306f\u3001inline \u304b attachment \u4ee5\u5916\u306f\u6307\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002disposition=[" + this.disposition + "]";
            throw new HybsSystemException(string2);
        }
    }

    public void setSheetName(String string) {
        this.sheetName = StringUtil.nval((String)this.getRequestParameter(string), (String)this.sheetName);
    }

    public void setRefSheetName(String string) {
        this.refSheetName = StringUtil.nval((String)this.getRequestParameter(string), (String)this.refSheetName);
    }

    public void setFontName(String string) {
        this.fontName = StringUtil.nval((String)this.getRequestParameter(string), (String)this.fontName);
    }

    public void setFontPoint(String string) {
        this.fontPoint = StringUtil.nval((String)this.getRequestParameter(string), (String)this.fontPoint);
    }

    public void setUseNumber(String string) {
        this.useNumber = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useNumber);
    }

    public void setColumns(String string) {
        this.columns = StringUtil.nval((String)this.getRequestParameter(string), (String)this.columns);
    }

    public void setUseRenderer(String string) {
        this.useRenderer = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useRenderer);
    }

    public void setSelectedAll(String string) {
        this.selectedAll = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.selectedAll);
    }

    public void setBeforeDelete(String string) {
        this.beforeDelete = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.beforeDelete);
    }

    protected void addParam(HybsEntry hybsEntry) {
        if (this.param == null) {
            this.param = new ArrayList<HybsEntry>();
        }
        this.param.add(hybsEntry);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("BASE_URL", (Object)this.BASE_URL).println("separator", (Object)this.separator).println("headerSequence", (Object)this.headerSequence).println("fileURL", (Object)this.fileURL).println("filename", (Object)this.filename).println("refFileURL", (Object)this.refFileURL).println("refFilename", (Object)this.refFilename).println("encode", (Object)this.encode).println("writerClass", (Object)this.writerClass).println("fileAppend", (Object)this.fileAppend).println("direct", (Object)this.direct).println("zip", (Object)this.zip).println("disposition", (Object)this.disposition).println("tableId", (Object)this.tableId).println("sheetName", (Object)this.sheetName).println("refSheetName", (Object)this.refSheetName).println("useNumber", (Object)this.useNumber).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }
}

