/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.resource;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.opengion.fukurou.db.DBUtil;
import org.opengion.fukurou.util.ApplicationInfo;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.resource.LabelData;

final class LabelDataLoader {
    private final String DBID = HybsSystem.sys("RESOURCE_DBID");
    private static final String QUERY = "select CLM,SNAME,LNAME,DESCRIPTION ,FGLOAD from GEA08 where SYSTEM_ID in ( ?,'**') and LANG=? and FGJ='1' order by SYSTEM_ID,CLM,KBSAKU";
    private static final String QUERY2 = "select CLM,SNAME,LNAME,DESCRIPTION from GEA08 where SYSTEM_ID in ( ?,'**') and LANG=? and CLM=? and FGJ='1' order by SYSTEM_ID,KBSAKU";
    private final Map<String, LabelData> pool = Collections.synchronizedMap(new WeakHashMap());
    private final String SYSTEM_ID;
    private final String LANG;
    public static final boolean USE_DB_APPLICATION_INFO = HybsSystem.sysBool("USE_DB_APPLICATION_INFO");
    private final ApplicationInfo appInfo;

    LabelDataLoader(String string, String string2, boolean bl) {
        this.SYSTEM_ID = string;
        this.LANG = string2;
        if (USE_DB_APPLICATION_INFO) {
            this.appInfo = new ApplicationInfo();
            this.appInfo.setClientInfo(this.SYSTEM_ID, HybsSystem.HOST_ADRS, HybsSystem.HOST_NAME);
            this.appInfo.setModuleInfo("LabelDataLoader", null, null);
        } else {
            this.appInfo = null;
        }
        if (bl) {
            this.loadDBResource();
        }
    }

    private void loadDBResource() {
        String[] stringArray = new String[]{this.SYSTEM_ID, this.LANG};
        String[][] stringArray2 = DBUtil.dbExecute((String)QUERY, (String[])stringArray, (ApplicationInfo)this.appInfo, (String)this.DBID);
        int n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            if ("1".equals(stringArray2[i][4])) {
                this.pool.put(stringArray2[i][0], new LabelData(stringArray2[i]));
                continue;
            }
            if (this.pool.get(stringArray2[i][0]) == null) continue;
            this.pool.remove(stringArray2[i][0]);
        }
        System.out.println("  LabelDataLoader [" + n + "] loaded");
    }

    public LabelData getLabelData(String string) {
        LabelData labelData = this.pool.get(string);
        if (labelData == null) {
            String[] stringArray = new String[]{this.SYSTEM_ID, this.LANG, string};
            String[][] stringArray2 = DBUtil.dbExecute((String)QUERY2, (String[])stringArray, (ApplicationInfo)this.appInfo, (String)this.DBID);
            labelData = stringArray2.length > 0 ? new LabelData(stringArray2[stringArray2.length - 1]) : new LabelData(string);
            this.pool.put(string, labelData);
        }
        return labelData;
    }

    public Map<String, LabelData> getLabelMap(String string) {
        if (string == null || string.length() == 0) {
            String string2 = "\u30e9\u30d9\u30eb\u3092\u53d6\u5f97\u3059\u308b\u30af\u30a8\u30ea\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
            throw new HybsSystemException(string2);
        }
        String[][] stringArray = DBUtil.dbExecute((String)string, (String[])new String[0], (ApplicationInfo)this.appInfo);
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        int n = stringArray[0].length;
        if (n < 2) {
            String string3 = "\u30e9\u30d9\u30eb\u30ad\u30fc\u3001\u30e9\u30d9\u30eb\u540d\u79f0\u306e\u6307\u5b9a\u306f\u5fc5\u9808\u3067\u3059\u3002 SQL=" + string;
            throw new HybsSystemException(string3);
        }
        HashMap<String, LabelData> hashMap = new HashMap<String, LabelData>();
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = new String[]{stringArray[i][0], n == 2 ? stringArray[i][1] : stringArray[i][2], stringArray[i][1], "", ""};
            hashMap.put(stringArray[i][0], new LabelData(stringArray2));
        }
        return hashMap;
    }

    public void clear(String string) {
        this.pool.remove(string);
    }

    public void clear() {
        this.pool.clear();
    }
}

