/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.db;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.opengion.fukurou.db.ConnectionFactory;
import org.opengion.fukurou.db.Transaction;
import org.opengion.fukurou.util.ApplicationInfo;
import org.opengion.fukurou.util.Closer;

public class TransactionImpl
implements Transaction {
    private static final String VERSION = "5.1.9.0 (2010/08/01)";
    private static final long serialVersionUID = 5190L;
    private static final String DBID = "DEFAULT";
    private final ApplicationInfo appInfo;
    private Connection defconn = null;
    private final Map<String, Connection> dbidMap = new HashMap<String, Connection>();
    private boolean isCommit = false;
    private boolean isRollback = false;
    private boolean isError = false;
    private boolean isFinish = false;

    public TransactionImpl(ApplicationInfo applicationInfo) {
        this.appInfo = applicationInfo;
    }

    @Override
    public Connection getConnection(String string) {
        if (string == null || string.length() == 0 || DBID.equalsIgnoreCase(string)) {
            if (this.defconn == null) {
                this.defconn = ConnectionFactory.connection(DBID, this.appInfo);
            }
            return this.defconn;
        }
        String string2 = string.toUpperCase(Locale.JAPAN);
        Connection connection = this.dbidMap.get(string2);
        if (connection == null) {
            connection = ConnectionFactory.connection(string2, this.appInfo);
            this.dbidMap.put(string2, connection);
        }
        return connection;
    }

    @Override
    public boolean commit() {
        this.isCommit = true;
        return true;
    }

    @Override
    public boolean rollback() {
        this.isRollback = true;
        this.isError = true;
        return true;
    }

    @Override
    public boolean close() {
        return this.close(false);
    }

    @Override
    public boolean close(boolean bl) {
        if (bl) {
            this.isError = true;
        }
        return true;
    }

    public void finish() {
        this.isFinish = true;
    }

    public void realClose() {
        if (this.defconn != null) {
            this.connClose(this.defconn, DBID);
        }
        for (Map.Entry<String, Connection> entry : this.dbidMap.entrySet()) {
            String string = entry.getKey();
            Connection connection = entry.getValue();
            this.connClose(connection, string);
        }
        this.defconn = null;
        this.dbidMap.clear();
        this.isCommit = false;
        this.isRollback = false;
        this.isError = false;
        this.isFinish = false;
    }

    private void connClose(Connection connection, String string) {
        if (this.isCommit || this.isRollback) {
            if (this.isCommit && this.isFinish && !this.isError && !this.isRollback) {
                Closer.commit(connection);
            } else {
                Closer.rollback(connection);
            }
        }
        if (this.isError) {
            ConnectionFactory.remove(connection, string);
        } else {
            ConnectionFactory.close(connection, string);
        }
    }
}

