/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.io.File;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.db.DBTableModelUtil;
import org.opengion.hayabusa.servlet.MultipartRequest;
import org.opengion.hayabusa.taglib.CommonTagSupport;

public class FileUploadTag
extends CommonTagSupport {
    private static final String VERSION = "4.0.0 (2005/08/31)";
    private static final long serialVersionUID = 4000L;
    private static final String[] names = new String[]{"KEY", "VALUE", "ISFILE"};
    private static final String ENCODE = "UTF-8";
    private String fileURL = HybsSystem.sys("FILE_URL");
    private String filename = null;
    private int maxPostSize = 0xA00000;
    private String tableId = "h_tblmdl";

    @Override
    public int doEndTag() {
        this.debugPrint();
        this.startQueryTransaction(this.tableId);
        HttpServletRequest httpServletRequest = (HttpServletRequest)this.getRequest();
        try {
            String string = HybsSystem.url2dir(this.fileURL);
            File file = new File(string);
            if (!file.exists() && !file.mkdirs()) {
                String string2 = "\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002[" + string + "]";
                throw new HybsSystemException(string2);
            }
            MultipartRequest multipartRequest = new MultipartRequest(httpServletRequest, string, this.maxPostSize, ENCODE, this.filename);
            DBTableModel dBTableModel = this.makeDBTable(multipartRequest);
            if (!this.commitTableObject(this.tableId, dBTableModel)) {
                this.jspPrint("FileUploadTag Query\u51e6\u7406\u304c\u5272\u308a\u8fbc\u307e\u308c\u307e\u3057\u305f\u3002DBTableModel \u306f\u767b\u9332\u3057\u307e\u305b\u3093\u3002");
                return 5;
            }
        }
        catch (IOException iOException) {
            String string = "\u30d5\u30a1\u30a4\u30eb\u767b\u9332\u30a8\u30e9\u30fc\uff01" + iOException.getMessage() + HybsSystem.CR + "(" + this.toString() + HybsSystem.CR + "FileURL=" + this.fileURL + ")";
            throw new HybsSystemException(string, iOException);
        }
        return 6;
    }

    @Override
    protected void release2() {
        super.release2();
        this.fileURL = HybsSystem.sys("FILE_URL");
        this.maxPostSize = 0xA00000;
        this.tableId = "h_tblmdl";
        this.filename = null;
    }

    private DBTableModel makeDBTable(MultipartRequest multipartRequest) {
        String[] stringArray;
        String string;
        Object object;
        Object object2;
        DBTableModel dBTableModel = DBTableModelUtil.newDBTable();
        dBTableModel.init(names.length);
        for (int i = 0; i < names.length; ++i) {
            object2 = this.getDBColumn(names[i]);
            dBTableModel.setDBColumn(i, (DBColumn)object2);
        }
        object2 = multipartRequest.getFilenames();
        for (int i = 0; i < ((String[])object2).length; ++i) {
            String string2 = object2[i];
            object = multipartRequest.getFile(string2);
            if (object == null) continue;
            string = multipartRequest.getFilesystemName(string2);
            String[] stringArray2 = new String[]{string2, string, "1"};
            dBTableModel.addColumnValues(stringArray2);
            this.setRequestAttribute(string2, string);
            stringArray = string2 + "_ORG";
            string = multipartRequest.getOriginalFileName(string2);
            stringArray2 = new String[]{stringArray, string, "2"};
            dBTableModel.addColumnValues(stringArray2);
            this.setRequestAttribute((String)stringArray, string);
        }
        String[] stringArray3 = new String[]{"directory", this.fileURL, "0"};
        dBTableModel.addColumnValues(stringArray3);
        this.setRequestAttribute("directory", this.fileURL);
        String[] stringArray4 = multipartRequest.getParameterNames();
        for (int i = 0; i < stringArray4.length; ++i) {
            object = stringArray4[i];
            if ("h_rowSel".equals(object)) {
                this.setRequestAttribute((String)object, multipartRequest.getIntParameters((String)object));
                continue;
            }
            string = multipartRequest.getParameter((String)object);
            if ("0".equals(string) && (stringArray = multipartRequest.getParameters((String)object)) != null && stringArray.length > 1) {
                for (int j = 0; j < stringArray.length; ++j) {
                    if (!"1".equals(stringArray[j])) continue;
                    string = "1";
                    break;
                }
            }
            stringArray3 = new String[]{object, string, "0"};
            dBTableModel.addColumnValues(stringArray3);
            this.setRequestAttribute((String)object, string);
        }
        String[] stringArray5 = new String[((String[])object2).length + stringArray4.length];
        System.arraycopy(object2, 0, stringArray5, 0, ((String[])object2).length);
        System.arraycopy(stringArray4, 0, stringArray5, ((String[])object2).length, stringArray4.length);
        this.setParameterNames(stringArray5);
        return dBTableModel;
    }

    public void setFileURL(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string2 != null) {
            char c = string2.charAt(string2.length() - 1);
            if (c != '/' && c != '\\') {
                string2 = string2 + "/";
            }
            this.fileURL = StringUtil.urlAppend((String)this.fileURL, (String)string2);
        }
    }

    public void setMaxPostSize(String string) {
        this.maxPostSize = StringUtil.nval((String)this.getRequestParameter(string), (int)this.maxPostSize);
    }

    public void setTableId(String string) {
        this.tableId = StringUtil.nval((String)this.getRequestParameter(string), (String)this.tableId);
    }

    public void setFilename(String string) {
        this.filename = StringUtil.nval((String)this.getRequestParameter(string), (String)this.filename);
    }

    @Override
    protected String getTagName() {
        return "upload";
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("names", (Object[])names).println("ENCODE", (Object)ENCODE).println("fileURL", (Object)this.fileURL).println("filename", (Object)this.filename).println("maxPostSize", (Object)this.maxPostSize).println("tableId", (Object)this.tableId).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }
}

