/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

class TimeStampObject
implements Comparable<TimeStampObject> {
    private final long timeStamp;
    private final long limitTime;
    private final int hcode;

    public TimeStampObject(Object object, int n) {
        if (object == null) {
            String string = "TimeStampObject \u306e\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u306b\u3001NULL \u306f\u30bb\u30c3\u30c8\u3067\u304d\u307e\u305b\u3093\u3002";
            throw new IllegalArgumentException(string);
        }
        this.timeStamp = System.currentTimeMillis();
        this.limitTime = n > 0 ? this.timeStamp + (long)n * 1000L : Long.MAX_VALUE;
        this.hcode = (int)(this.timeStamp & Integer.MAX_VALUE) ^ object.hashCode();
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public boolean isTimeOver() {
        return System.currentTimeMillis() > this.limitTime;
    }

    public boolean equals(Object object) {
        if (object instanceof TimeStampObject) {
            TimeStampObject timeStampObject = (TimeStampObject)object;
            return this.hcode == timeStampObject.hcode && this.timeStamp == timeStampObject.timeStamp;
        }
        return false;
    }

    public int hashCode() {
        return this.hcode;
    }

    @Override
    public int compareTo(TimeStampObject timeStampObject) {
        long l = this.timeStamp - timeStampObject.timeStamp;
        if (l > 0L) {
            return 1;
        }
        if (l < 0L) {
            return -1;
        }
        if (this.equals(timeStampObject)) {
            return 0;
        }
        return this.hcode - timeStampObject.hcode;
    }

    public String toString() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss", Locale.JAPAN);
        return "[Create Time = " + simpleDateFormat.format(new Date(this.timeStamp)) + " , Time Over = " + (int)((double)(this.limitTime - System.currentTimeMillis()) / 1000.0) + "(S)]";
    }
}

