/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.LinkedHashMap;
import java.util.Map;
import jcifs.smb.SmbFile;
import org.opengion.fukurou.util.AbstractConnect;
import org.opengion.fukurou.util.Argument;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.FileUtil;

public final class SMBConnect
extends AbstractConnect {
    private String domain = null;
    private String connURI = null;
    private static final Map<String, String> mustProparty = new LinkedHashMap<String, String>();
    private static final Map<String, String> usableProparty;
    private static final String[] CMD_LST;

    @Override
    public void connect() {
        if (this.isDisplay) {
            System.out.println("CONNECT: HOST=" + this.host + ",USER=" + this.user + ",PORT=" + this.port);
        }
        if (this.host == null) {
            this.errAppend((Object)"host \u306f\u3001\u5fc5\u9808\u3067\u3059\u3002");
            throw new RuntimeException(this.getErrMsg());
        }
        this.connURI = "smb://" + (this.domain == null ? "" : this.domain + ";") + (this.user == null ? "" : this.user) + (this.passwd == null ? "" : ":" + this.passwd) + (this.user == null ? "" : "@") + this.host + (this.port == null ? "" : ":" + this.port);
        if (this.isDebug) {
            System.out.println("connURI=" + this.connURI);
        }
    }

    @Override
    public void disconnect() {
        if (this.isDisplay) {
            System.out.println("DISCONNECT:");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void actionGET(String string, String string2) throws IOException {
        if (this.isDebug) {
            System.out.println("GET: " + string2 + " => " + string);
        }
        SmbFile smbFile = this.makeSmbURI(string2);
        if (this.isMkdirs) {
            this.makeLocalDir(string);
        }
        BufferedInputStream bufferedInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(smbFile.getInputStream());
            fileOutputStream = new FileOutputStream(string);
            FileUtil.copy(bufferedInputStream, fileOutputStream);
        }
        catch (Throwable throwable) {
            Closer.ioClose(bufferedInputStream);
            Closer.ioClose(fileOutputStream);
            throw throwable;
        }
        Closer.ioClose(bufferedInputStream);
        Closer.ioClose(fileOutputStream);
    }

    @Override
    protected void actionGETdir(String string, String string2) throws IOException {
        SmbFile smbFile = this.makeSmbURI(string2);
        SmbFile[] smbFileArray = smbFile.listFiles();
        for (int i = 0; i < smbFileArray.length; ++i) {
            String string3 = smbFileArray[i].getName();
            if (smbFileArray[i].isDirectory()) {
                this.actionGETdir(this.addFile(string, string3), this.addFile(string2, string3));
                continue;
            }
            this.actionGET(this.addFile(string, string3), this.addFile(string2, string3));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void actionPUT(String string, String string2) throws IOException {
        Object object;
        Object object2;
        SmbFile smbFile;
        if (this.isDebug) {
            System.out.println("PUT: " + string + " => " + string2);
        }
        if ((smbFile = this.makeSmbURI(string2)).exists()) {
            smbFile.delete();
        } else if (this.isMkdirs && !(object2 = new SmbFile((String)(object = smbFile.getParent()))).exists()) {
            object2.mkdirs();
        }
        object = null;
        object2 = null;
        try {
            object = new FileInputStream(string);
            object2 = new BufferedOutputStream(smbFile.getOutputStream());
            FileUtil.copy((InputStream)object, (OutputStream)object2);
        }
        finally {
            Closer.ioClose((Closeable)object);
            Closer.ioClose((Closeable)object2);
        }
    }

    @Override
    protected void actionDEL(String string) throws IOException {
        if (this.isDebug) {
            System.out.println("DEL: " + string);
        }
        SmbFile smbFile = this.makeSmbURI(string);
        smbFile.delete();
    }

    @Override
    protected void actionDELdir(String string) throws IOException {
        SmbFile smbFile = this.makeSmbURI(string);
        SmbFile[] smbFileArray = smbFile.listFiles();
        for (int i = 0; i < smbFileArray.length; ++i) {
            String string2 = this.addFile(string, smbFileArray[i].getName());
            if (smbFileArray[i].isDirectory()) {
                this.actionDELdir(string2);
                continue;
            }
            this.actionDEL(string2);
        }
        smbFile.delete();
    }

    private SmbFile makeSmbURI(String string) throws MalformedURLException {
        String string2 = string.startsWith("smb://") ? string : (string.startsWith("/") ? this.connURI + string : this.connURI + "/" + string);
        return new SmbFile(string2);
    }

    public void setDomain(String string) {
        this.domain = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        Argument argument = new Argument("org.opengion.fukurou.util.SMBConnect");
        argument.setMustProparty(mustProparty);
        argument.setUsableProparty(usableProparty);
        argument.setArgument(stringArray);
        SMBConnect sMBConnect = new SMBConnect();
        String string = argument.getProparty("host");
        String string2 = argument.getProparty("user");
        String string3 = argument.getProparty("passwd");
        sMBConnect.setHostUserPass(string, string2, string3);
        sMBConnect.setDomain(argument.getProparty("domain"));
        sMBConnect.setPort(argument.getProparty("port"));
        sMBConnect.setMkdirs(argument.getProparty("mkdirs", true));
        sMBConnect.setDisplay(argument.getProparty("display", false));
        sMBConnect.setDebug(argument.getProparty("debug", false));
        try {
            sMBConnect.connect();
            String string4 = argument.getProparty("command", "GET", CMD_LST);
            String string5 = argument.getProparty("localFile");
            String string6 = argument.getProparty("remoteFile");
            sMBConnect.action(string4, string5, string6);
        }
        catch (RuntimeException runtimeException) {
            System.err.println(sMBConnect.getErrMsg());
        }
        finally {
            sMBConnect.disconnect();
        }
    }

    static {
        mustProparty.put("host", "\u63a5\u7d9a\u5148\u306eSmb\u30b5\u30fc\u30d0\u30fc\u306e\u30a2\u30c9\u30ec\u30b9\u307e\u305f\u306f\u3001\u30b5\u30fc\u30d0\u30fc\u540d(\u5fc5\u9808)");
        mustProparty.put("user", "\u63a5\u7d9a\u3059\u308b\u30e6\u30fc\u30b6\u30fc\u540d(\u5fc5\u9808)");
        mustProparty.put("passwd", "\u63a5\u7d9a\u3059\u308b\u30e6\u30fc\u30b6\u30fc\u306e\u30d1\u30b9\u30ef\u30fc\u30c9(\u5fc5\u9808)");
        mustProparty.put("command", "Smb\u30b5\u30fc\u30d0\u30fc\u5074\u3067\u306e\u51e6\u7406\u306e\u65b9\u6cd5(GET/PUT/DEL/GETDIR/PUTDIR/DELDIR)\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002(\u5fc5\u9808)");
        mustProparty.put("remoteFile", "\u63a5\u7d9a\u5148\u306eSmb\u30b5\u30fc\u30d0\u30fc\u5074\u306e\u30d5\u30a1\u30a4\u30eb\u540d(\u5fc5\u9808)");
        usableProparty = new LinkedHashMap<String, String>();
        usableProparty.put("localFile", "\u30ed\u30fc\u30ab\u30eb\u306e\u30d5\u30a1\u30a4\u30eb\u540d");
        usableProparty.put("domain", "\u63a5\u7d9a\u5148\u306b\u30ed\u30b0\u30a4\u30f3\u3059\u308b\u30c9\u30e1\u30a4\u30f3\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002");
        usableProparty.put("port", "\u63a5\u7d9a\u306b\u5229\u7528\u3059\u308b\u30dd\u30fc\u30c8\u756a\u53f7\u3092\u8a2d\u5b9a\u3057\u307e\u3059\u3002");
        usableProparty.put("mkdirs", "\u53d7\u3051\u5074\u30d5\u30a1\u30a4\u30eb(GET\u6642:LOCAL\u3001PUT\u6642:Smb\u30b5\u30fc\u30d0\u30fc)\u306b\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092\u4f5c\u6210\u3059\u308b\u304b\u3069\u3046\u304b\u3002(\u521d\u671f\u5024\uff1atrue)");
        usableProparty.put("display", "[false/true]:true\u306f\u3001\u691c\u7d22\u72b6\u6cc1\u3092\u8868\u793a\u3057\u307e\u3059\u3002(\u521d\u671f\u5024\uff1afalse\uff09");
        usableProparty.put("debug", "\u30c7\u30d0\u30c3\u30b0\u60c5\u5831\u3092\u6a19\u6e96\u51fa\u529b\u306b\u8868\u793a\u3059\u308b(true)\u304b\u3057\u306a\u3044(false)\u304b" + CR + "\uff08\u521d\u671f\u5024 false:\u8868\u793a\u3057\u306a\u3044)");
        CMD_LST = new String[]{"GET", "PUT", "DEL", "GETDIR", "PUTDIR", "DELDIR"};
    }
}

