/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.util;

import java.awt.Color;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.opengion.fukurou.util.CSVTokenizer;

public final class StringUtil {
    private static final int BUFFER_MIDDLE = 200;
    private static final String CR = System.getProperty("line.separator");
    public static final Charset DEFAULT_CHARSET = Charset.defaultCharset();
    private static final String MODULUS_43 = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%";
    private static final String[] UTF_STR = new String[]{"&#x0000", "&#x000", "&#x00", "&#x0", "&#x"};
    private static final Map<String, Color> CLR_MAP = new HashMap<String, Color>();

    private StringUtil() {
    }

    public static String urlEncode(String string) {
        if (string == null) {
            return "";
        }
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string2 = "UnsupportedEncodingException [UTF-8]" + CR + unsupportedEncodingException.getMessage();
            throw new RuntimeException(string2, unsupportedEncodingException);
        }
        catch (RuntimeException runtimeException) {
            String string3 = "\u4e88\u671f\u305b\u306c\u30a8\u30e9\u30fc value=[" + string + "] , encode=[UTF-8]" + CR + runtimeException.getMessage();
            throw new RuntimeException(string3, runtimeException);
        }
    }

    public static String urlDecode(String string) {
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string2 = "UnsupportedEncodingException [UTF-8]" + CR + unsupportedEncodingException.getMessage();
            throw new RuntimeException(string2, unsupportedEncodingException);
        }
        catch (RuntimeException runtimeException) {
            String string3 = "\u4e88\u671f\u305b\u306c\u30a8\u30e9\u30fc value=[" + string + "] , encode=[UTF-8]" + CR + runtimeException.getMessage();
            throw new RuntimeException(string3, runtimeException);
        }
    }

    public static String rTrim(String string) {
        int n;
        int n2;
        if (string == null) {
            return null;
        }
        for (n2 = n = string.length(); 0 < n2 && string.charAt(n2 - 1) <= ' '; --n2) {
        }
        return n2 < n ? string.substring(0, n2) : string;
    }

    public static String toNumber(String string) {
        int n;
        int n2;
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        int n3 = string2.indexOf(46);
        if (n3 >= 0) {
            for (n2 = n = string2.length(); n3 < n2 && ".0".indexOf(string2.charAt(n2 - 1)) >= 0; --n2) {
            }
        }
        if (n2 < n) {
            string2 = string2.substring(0, n2);
        }
        if (n3 == 0) {
            string2 = "0" + string2;
        }
        return string2;
    }

    public static String lTrim0(String string) {
        int n;
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        int n2 = string2.length();
        for (n = 0; n2 > n && string2.charAt(n) == '0'; ++n) {
        }
        if (n == 0) {
            return string2;
        }
        if (n == n2) {
            return "0";
        }
        if (string2.charAt(n) == '.') {
            return "0" + string2.substring(n);
        }
        return string2.substring(n);
    }

    public static String[] rTrims(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return stringArray;
        }
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = StringUtil.rTrim(stringArray[i]);
        }
        return stringArray2;
    }

    public static String csvOutQuote(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        if (n < 2 || string.charAt(0) != '\"' || string.charAt(n - 1) != '\"') {
            return string;
        }
        return string.substring(1, n - 1);
    }

    public static String makeString(byte[] byArray, int n, int n2, String string) {
        if (string.startsWith("Unicode")) {
            String string2 = "Unicode\u6587\u5b57\u5217\u306f\u3001\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3002[" + string + "]" + CR;
            throw new RuntimeException(string2);
        }
        String string3 = null;
        if (byArray != null) {
            try {
                string3 = new String(byArray, n, n2, string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                String string4 = "\u6587\u5b57\u5909\u63db\u30b3\u30fc\u30c9\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002[" + string + "]" + CR + unsupportedEncodingException.getMessage();
                throw new RuntimeException(string4, unsupportedEncodingException);
            }
        }
        return string3;
    }

    public static byte[] makeByte(String string, String string2) {
        byte[] byArray = new byte[]{};
        if (string != null) {
            try {
                byArray = string.getBytes(string2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                String string3 = "\u6587\u5b57\u5909\u63db\u30b3\u30fc\u30c9\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002[" + string2 + "]" + CR + unsupportedEncodingException.getMessage();
                throw new RuntimeException(string3, unsupportedEncodingException);
            }
        }
        return byArray;
    }

    public static String stringXFill(String string, int n) {
        char[] cArray = string == null ? new char[]{} : string.toCharArray();
        int n2 = cArray.length;
        if (n < n2) {
            String string2 = "\u5143\u306e\u6587\u5b57\u6570\u304c\u30d5\u30a9\u30fc\u30e0\u3088\u308a\u9577\u3044\u3067\u3059\u3002\uff08\u6570\u5b57\u304c\u58ca\u308c\u307e\u3059\u3002\uff09su_fill[" + n + "], len[" + n2 + "]" + CR + "input=[" + string + "]" + CR;
            throw new RuntimeException(string2);
        }
        char[] cArray2 = new char[n];
        Arrays.fill(cArray2, ' ');
        System.arraycopy(cArray, 0, cArray2, 0, n2);
        return new String(cArray2);
    }

    public static String stringFill(String string, int n, String string2) {
        int n2;
        if (n < 0) {
            String string3 = "\u6307\u5b9a\u6587\u5b57\u6570\u304c\u8ca0\u3067\u3059\u3002[" + n + "]";
            throw new RuntimeException(string3);
        }
        byte[] byArray = StringUtil.makeByte(string, string2);
        int n3 = byArray.length;
        if (n3 >= n) {
            return StringUtil.makeString(byArray, 0, n, string2);
        }
        byte[] byArray2 = StringUtil.makeByte(" ", string2);
        int n4 = byArray2.length;
        if (n4 == 4) {
            byArray2[0] = byArray2[2];
            byArray2[1] = byArray2[3];
            n4 = 2;
        }
        byte[] byArray3 = new byte[n];
        for (n2 = 0; n2 < n3; ++n2) {
            byArray3[n2] = byArray[n2];
        }
        n2 = 0;
        for (int i = n3; i < n; ++i) {
            if (n2 >= n4) {
                n2 = 0;
            }
            byArray3[i] = byArray2[n2++];
        }
        return StringUtil.makeString(byArray3, 0, n, string2);
    }

    public static String intFill(String string, int n) {
        if (n < 0) {
            String string2 = "\u6307\u5b9a\u6587\u5b57\u6570\u304c\u8ca0\u3067\u3059\u3002[" + n + "]";
            throw new RuntimeException(string2);
        }
        char[] cArray = new char[n];
        Arrays.fill(cArray, '0');
        if (string == null) {
            return new String(cArray);
        }
        char[] cArray2 = string.toCharArray();
        int n2 = cArray2.length;
        if (n < n2) {
            String string3 = "\u5143\u306e\u6587\u5b57\u6570\u304c\u30d5\u30a9\u30fc\u30e0\u3088\u308a\u9577\u3044\u3067\u3059\u3002\uff08\u6570\u5b57\u304c\u58ca\u308c\u307e\u3059\u3002\uff09 su_fill[" + n + "], len[" + n2 + "]";
            throw new RuntimeException(string3);
        }
        System.arraycopy(cArray2, 0, cArray, n - n2, n2);
        return new String(cArray);
    }

    public static String stringKFill(String string, int n, String string2) {
        int n2;
        if (n < 0) {
            String string3 = "\u6307\u5b9a\u6587\u5b57\u6570\u304c\u8ca0\u3067\u3059\u3002[" + n + "]";
            throw new RuntimeException(string3);
        }
        byte[] byArray = StringUtil.makeByte(string, string2);
        int n3 = byArray.length;
        if (n3 >= n) {
            return StringUtil.makeString(byArray, 0, n, string2);
        }
        byte[] byArray2 = StringUtil.makeByte("\u3000", string2);
        int n4 = byArray2.length;
        byte[] byArray3 = new byte[n];
        for (n2 = 0; n2 < n3; ++n2) {
            byArray3[n2] = byArray[n2];
        }
        n2 = 0;
        for (int i = n3; i < n; ++i) {
            if (n2 >= n4) {
                n2 = 0;
            }
            byArray3[i] = byArray2[n2++];
        }
        return StringUtil.makeString(byArray3, 0, n, string2);
    }

    public static String realFill(String string, double d) {
        if (d < 0.0) {
            String string2 = "\u6307\u5b9a\u6587\u5b57\u6570\u304c\u8ca0\u3067\u3059\u3002[" + d + "]";
            throw new RuntimeException(string2);
        }
        int n = (int)d;
        int n2 = (int)(d * 10.0 - (double)(n * 10));
        char[] cArray = new char[n + n2 + 1];
        Arrays.fill(cArray, '0');
        if (string == null) {
            cArray[n] = 46;
            return new String(cArray);
        }
        char[] cArray2 = string.toCharArray();
        int n3 = cArray2.length;
        int n4 = string.indexOf(46);
        if (n4 < 0) {
            String string3 = "\u5143\u306e\u6587\u5b57\u5217\u306b\u5c0f\u6570\u70b9\u304c\u3001\u542b\u307e\u308c\u307e\u305b\u3093\u3002";
            throw new RuntimeException(string3);
        }
        int n5 = n4;
        int n6 = n3 - n4 - 1;
        int n7 = n - n5;
        if (n7 < 0) {
            String string4 = "\u5143\u306e\u6570\u5b57\u304c\u3001\u30d5\u30a9\u30fc\u30e0\u3088\u308a\u9577\u3044\u3067\u3059\u3002\uff08\u6570\u5b57\u304c\u58ca\u308c\u307e\u3059\u3002\uff09 form[" + d + "]";
            throw new RuntimeException(string4);
        }
        int n8 = n2 < n6 ? n + n2 + 1 : n + n6 + 1;
        int n9 = 0;
        while (n7 < n8) {
            cArray[n7++] = cArray2[n9++];
        }
        return new String(cArray);
    }

    public static String replace(String string, String string2, String string3) {
        if (string == null || string2 == null || string3 == null || string.indexOf(string2) < 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n = 0;
        int n2 = string.indexOf(string2, n);
        while (n2 >= 0) {
            stringBuilder.append(string.substring(n, n2));
            stringBuilder.append(string3);
            n = n2 + string2.length();
            n2 = string.indexOf(string2, n);
        }
        if (n > 0) {
            stringBuilder.append(string.substring(n));
            return stringBuilder.toString();
        }
        return string;
    }

    public static String array2csv(String[] stringArray) {
        return StringUtil.array2line(stringArray, ",", 0);
    }

    public static String array2line(String[] stringArray, String string) {
        return StringUtil.array2line(stringArray, string, 0);
    }

    public static String array2line(String[] stringArray, String string, int n) {
        if (stringArray == null || stringArray.length <= n) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append(StringUtil.valueOf(stringArray[n]));
        for (int i = n + 1; i < stringArray.length; ++i) {
            stringBuilder.append(string);
            stringBuilder.append(StringUtil.valueOf(stringArray[i]));
        }
        return stringBuilder.toString();
    }

    public static Object[] enume2Array(Enumeration<?> enumeration) {
        if (enumeration == null || !enumeration.hasMoreElements()) {
            return new Object[0];
        }
        ArrayList arrayList = new ArrayList();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        return arrayList.toArray();
    }

    public static Object[] enume2Array(Enumeration<?> enumeration, Object[] objectArray) {
        if (enumeration == null || !enumeration.hasMoreElements()) {
            return objectArray;
        }
        ArrayList arrayList = new ArrayList();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        return arrayList.toArray(objectArray);
    }

    public static String iterator2line(Iterator<?> iterator, String string) {
        if (iterator == null || !iterator.hasNext()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append(StringUtil.valueOf(iterator.next()));
        while (iterator.hasNext()) {
            stringBuilder.append(string);
            stringBuilder.append(StringUtil.valueOf(iterator.next()));
        }
        return stringBuilder.toString();
    }

    public static String[] csv2Array(String string) {
        return StringUtil.csv2Array(string, ',', 0);
    }

    public static String[] csv2Array(String string, char c) {
        return StringUtil.csv2Array(string, c, 0);
    }

    public static String[] csv2Array(String string, char c, int n) {
        int n2;
        if (string == null || string.length() == 0) {
            return new String[0];
        }
        CSVTokenizer cSVTokenizer = new CSVTokenizer(string, c);
        int n3 = n > 0 ? n : cSVTokenizer.countTokens();
        String[] stringArray = new String[n3];
        for (n2 = 0; n2 < n3 && cSVTokenizer.hasMoreTokens(); ++n2) {
            stringArray[n2] = cSVTokenizer.nextToken().trim();
        }
        while (n2 < n3) {
            stringArray[n2] = "";
            ++n2;
        }
        return stringArray;
    }

    public static String[] csv2ArrayOnly(String string) {
        if (string == null || string.length() == 0) {
            return new String[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.length() <= 0) continue;
            arrayList.add(string2);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String valueOf(Object object) {
        if (object == null) {
            return "";
        }
        return object.toString();
    }

    public static String htmlFilter(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(200);
        block7: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block7;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    stringBuilder.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    stringBuilder.append("&#39;");
                    continue block7;
                }
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block7;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    public static String quoteFilter(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        if (string.indexOf(39) < 0 && string.indexOf(34) < 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        block4: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': {
                    stringBuilder.append("\\x22");
                    continue block4;
                }
                case '\'': {
                    stringBuilder.append("\\x27");
                    continue block4;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    public static String deleteChar(String string, char c) {
        if (string == null || string.indexOf(c) < 0) {
            return string;
        }
        char[] cArray = string.toCharArray();
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == c) continue;
            cArray[n] = cArray[i];
            ++n;
        }
        return String.valueOf(cArray, 0, n);
    }

    public static int countChar(String string, char c) {
        if (string == null || string.indexOf(c) < 0) {
            return 0;
        }
        char[] cArray = string.toCharArray();
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != c) continue;
            ++n;
        }
        return n;
    }

    public static String code39(String string, boolean bl) {
        char c;
        String string2;
        String string3 = string2 = string == null ? "" : string;
        if (!bl) {
            return "*" + string2 + "*";
        }
        int n = 0;
        for (c = '\u0000'; c < string2.length(); ++c) {
            int n2 = MODULUS_43.indexOf(string2.charAt(c));
            if (n2 < 0) {
                String string4 = "\u6307\u5b9a\u306e\u6587\u5b57\u4e2d\u306b\u3001CODE39 \u898f\u5b9a\u5916\u6587\u5b57\u304c\u4f7f\u7528\u3055\u308c\u3066\u3044\u307e\u3059\u3002[" + string2.charAt(c) + "]";
                throw new RuntimeException(string4);
            }
            n += n2;
        }
        c = MODULUS_43.charAt(n % 43);
        return "*" + string2 + c + "*";
    }

    public static String nval(String string, String string2) {
        return string == null || string.length() == 0 ? string2 : string;
    }

    public static int nval(String string, int n) {
        return string == null || string.length() == 0 ? n : Integer.parseInt(string);
    }

    public static long nval(String string, long l) {
        return string == null || string.length() == 0 ? l : Long.parseLong(string);
    }

    public static boolean nval(String string, boolean bl) {
        boolean bl2 = bl;
        if (string != null && string.length() != 0) {
            bl2 = "true".equalsIgnoreCase(string);
            if (string.length() == 1) {
                bl2 = !"0".equals(string);
            }
        }
        return bl2;
    }

    public static String nval2(String string, String string2) {
        return string == null || string.length() == 0 || "_".equals(string) ? string2 : string.intern();
    }

    public static String nval2(String string, String string2, String string3) {
        return string == null || string.length() == 0 ? string2 : ("_".equals(string) ? string3 : string.intern());
    }

    public static boolean isNull(String string) {
        if (string == null || string.length() == 0) {
            return true;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String stringStackTrace(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return String.valueOf(stringWriter);
    }

    public static String numberFormat(String string, int n) {
        char c;
        if (string == null || string.length() == 0) {
            return string;
        }
        String string2 = string.trim();
        if (string2.length() == 0) {
            return string2;
        }
        char[] cArray = string2.toCharArray();
        int n2 = 0;
        boolean bl = true;
        StringBuilder stringBuilder = new StringBuilder();
        while (n2 < cArray.length && (c = cArray[n2++]) != '.') {
            if (c == '-' || c == ',' || c == '0' && bl) continue;
            stringBuilder.append(c);
            bl = false;
        }
        if (stringBuilder.length() == 0) {
            stringBuilder.append('0');
        }
        for (c = stringBuilder.length() - 3; c > '\u0000'; c -= 3) {
            stringBuilder.insert((int)c, ',');
        }
        if (cArray[0] == '-') {
            stringBuilder.insert(0, '-');
        }
        StringBuilder stringBuilder2 = new StringBuilder();
        while (n2 < cArray.length) {
            stringBuilder2.append(cArray[n2++]);
        }
        while (stringBuilder2.length() < n) {
            stringBuilder2.append('0');
        }
        if (stringBuilder2.length() > 0) {
            stringBuilder.append('.').append((CharSequence)stringBuilder2);
        }
        return stringBuilder.toString();
    }

    public static Object newInstance(String string) {
        return StringUtil.newInstance(string, Thread.currentThread().getContextClassLoader());
    }

    public static Object newInstance(String string, ClassLoader classLoader) {
        try {
            return Class.forName(string, true, classLoader).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string2 = "\u30af\u30e9\u30b9\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002class=[" + string + "]" + CR + classNotFoundException.getMessage();
            throw new RuntimeException(string2, classNotFoundException);
        }
        catch (LinkageError linkageError) {
            String string3 = "\u30ea\u30f3\u30b1\u30fc\u30b8\u304c\u5931\u6557\u3057\u307e\u3057\u305f\u3002class=[" + string + "]" + CR + linkageError.getMessage();
            throw new RuntimeException(string3, linkageError);
        }
        catch (InstantiationException instantiationException) {
            String string4 = "\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u306e\u751f\u6210\u304c\u5931\u6557\u3057\u307e\u3057\u305f\u3002class=[" + string + "]" + CR + instantiationException.getMessage();
            throw new RuntimeException(string4, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            String string5 = "\u30af\u30e9\u30b9\u307e\u305f\u306f\u521d\u671f\u5316\u5b50\u306b\u30a2\u30af\u30bb\u30b9\u3067\u304d\u307e\u305b\u3093\u3002class=[" + string + "]" + CR + illegalAccessException.getMessage();
            throw new RuntimeException(string5, illegalAccessException);
        }
        catch (RuntimeException runtimeException) {
            String string6 = "\u4e88\u671f\u305b\u306c\u30a8\u30e9\u30fc class=[" + string + "]" + CR + runtimeException.getMessage();
            throw new RuntimeException(string6, runtimeException);
        }
    }

    public static String urlAppend(String string, String string2) {
        if (string2 == null || string2.length() == 0) {
            return string;
        }
        if (string == null || string.length() == 0 || string2.charAt(0) == '/' || string2.length() > 1 && string2.charAt(1) == ':' || string2.charAt(0) == '\\') {
            return string2;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + string2.length() + 1);
        char c = string.charAt(string.length() - 1);
        if (c == '/' || c == '\\') {
            stringBuilder.append(string).append(string2);
        } else {
            stringBuilder.append(string).append("/").append(string2);
        }
        return stringBuilder.toString();
    }

    public static String getUnicodeEscape(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() * 4);
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c > '\u00ff') {
                String string2 = Integer.toHexString(c);
                stringBuilder.append(UTF_STR[string2.length()]).append(string2).append(";");
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String getReplaceEscape(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        int n = stringBuilder.indexOf("&#");
        while (n >= 0) {
            if (n + 7 < stringBuilder.length() && stringBuilder.charAt(n + 7) == ';') {
                int n2 = Integer.parseInt(stringBuilder.substring(n + 3, n + 7), 16);
                stringBuilder.replace(n, n + 8, Character.toString((char)n2));
            }
            n = stringBuilder.indexOf("&#", n);
        }
        return stringBuilder.toString();
    }

    public static double parseDouble(String string) {
        double d;
        if (string == null || string.length() == 0 || string.equals("_")) {
            d = 0.0;
        } else if (string.indexOf(44) < 0) {
            d = Double.parseDouble(string);
        } else {
            char[] cArray = string.toCharArray();
            int n = 0;
            for (int i = 0; i < cArray.length; ++i) {
                if (cArray[i] == ',') continue;
                cArray[n] = cArray[i];
                ++n;
            }
            d = Double.parseDouble(String.valueOf(cArray, 0, n));
        }
        return d;
    }

    public static Color getColorInstance(String string) {
        Color color;
        if (string.startsWith("#")) {
            int n = Integer.parseInt(string.substring(1), 16);
            color = new Color(n);
        } else {
            color = CLR_MAP.get(string);
            if (color == null) {
                String string2 = "\u6307\u5b9a\u306e\u8272\u30b3\u30fc\u30c9\u306f\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093 Color=[" + string + "]" + CR + "ColorMap=" + CLR_MAP.keySet().toString();
                throw new RuntimeException(string2);
            }
        }
        return color;
    }

    public static String spanCut(String string) {
        String string2 = string;
        if (string != null && string.startsWith("<span")) {
            int n = string.indexOf(62);
            int n2 = string.indexOf("</span>", n);
            string2 = string.substring(n + 1, n2);
        }
        return string2;
    }

    static {
        CLR_MAP.put("BLACK", Color.BLACK);
        CLR_MAP.put("BLUE", Color.BLUE);
        CLR_MAP.put("CYAN", Color.CYAN);
        CLR_MAP.put("DARK_GRAY", Color.DARK_GRAY);
        CLR_MAP.put("GRAY", Color.GRAY);
        CLR_MAP.put("GREEN", Color.GREEN);
        CLR_MAP.put("LIGHT_GRAY", Color.LIGHT_GRAY);
        CLR_MAP.put("MAGENTA", Color.MAGENTA);
        CLR_MAP.put("ORANGE", Color.ORANGE);
        CLR_MAP.put("PINK", Color.PINK);
        CLR_MAP.put("RED", Color.RED);
        CLR_MAP.put("WHITE", Color.WHITE);
        CLR_MAP.put("YELLOW", Color.YELLOW);
        CLR_MAP.put("PURPLE", new Color(0x800080));
    }
}

