/**************************************************************************/
/* GF44 ( サンプル社員定義 )                                              */
/*                                                                        */
/* Created : 2012/03/27 19:47:13                                          */
/**************************************************************************/
CREATE TABLE GF44 (
   USERID  VARCHAR2(10)                 NOT NULL      /* 10  ユーザーID   */
 , NAME_JA VARCHAR2(200)                              /* 20  名称         */
 , UNIQ    NUMBER(9)        DEFAULT 0   NOT NULL      /* 800 ユニークキー */
 , FGJ     VARCHAR2(1)      DEFAULT '1' NOT NULL      /* 810 状態フラグ   */
 , DYSET   VARCHAR2(14)                               /* 820 登録日時     */
 , PGSET   VARCHAR2(10)                               /* 830 作成PG       */
 , PGPSET  VARCHAR2(10)                               /* 840 作成親PG     */
 , USRSET  VARCHAR2(10)                               /* 850 作成社員     */
 , DYUPD   VARCHAR2(14)                               /* 860 更新日時     */
 , PGUPD   VARCHAR2(10)                               /* 870 更新PG       */
 , PGPUPD  VARCHAR2(10)                               /* 880 更新親PG     */
 , USRUPD  VARCHAR2(10)                               /* 890 更新者       */
)
TABLESPACE GETBL01
STORAGE( INITIAL 64K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE GF44S00 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GF44T00 
BEFORE INSERT ON GF44
FOR EACH ROW 
BEGIN 
SELECT GF44S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

