/**************************************************************************/
/* GF28 ( 対訳テーブル )                                                  */
/*                                                                        */
/* Created : 2012/03/27 19:47:13                                          */
/**************************************************************************/
CREATE TABLE GF28 (
   GENBUN    VARCHAR2(500)                NOT NULL      /* 10  原文         */
 , LANG_GEN  VARCHAR2(2)                  NOT NULL      /* 20  原文言語     */
 , LANG_YAKU VARCHAR2(2)                  NOT NULL      /* 30  訳文言語     */
 , KBYAKU    VARCHAR2(1)                  NOT NULL      /* 40  訳文区分     */
 , YAKU      VARCHAR2(500)                              /* 50  訳文         */
 , ID        VARCHAR2(30)                               /* 60  ID           */
 , COMMENTS  VARCHAR2(500)                              /* 70  コメント     */
 , UNIQ      NUMBER(9)        DEFAULT 0   NOT NULL      /* 800 ユニークキー */
 , FGJ       VARCHAR2(1)      DEFAULT '1' NOT NULL      /* 810 状態フラグ   */
 , DYSET     VARCHAR2(14)                               /* 820 登録日時     */
 , PGSET     VARCHAR2(10)                               /* 830 作成PG       */
 , PGPSET    VARCHAR2(10)                               /* 840 作成親PG     */
 , USRSET    VARCHAR2(10)                               /* 850 作成社員     */
 , DYUPD     VARCHAR2(14)                               /* 860 更新日時     */
 , PGUPD     VARCHAR2(10)                               /* 870 更新PG       */
 , PGPUPD    VARCHAR2(10)                               /* 880 更新親PG     */
 , USRUPD    VARCHAR2(10)                               /* 890 更新者       */
)
TABLESPACE GETBL01
STORAGE( INITIAL 768K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE GF28S00 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GF28T00 
BEFORE INSERT ON GF28
FOR EACH ROW 
BEGIN 
SELECT GF28S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

