/**************************************************************************/
/* GE80 ( FAQテーブル )                                                   */
/*                                                                        */
/* Created : 2012/03/27 19:47:12                                          */
/**************************************************************************/
CREATE TABLE GE80 (
   UNIQ      NUMBER(9)         DEFAULT 0   NOT NULL      /* 10  ユニークキー   */
 , SYSTEM_ID VARCHAR2(10)                  NOT NULL      /* 20  システムID     */
 , SYSCODE   VARCHAR2(20)      DEFAULT '*' NOT NULL      /* 30  システムコード */
 , KBFAQ     VARCHAR2(1)       DEFAULT '0' NOT NULL      /* 40  FAQ区分        */
 , QANO      VARCHAR2(20)                  NOT NULL      /* 50  質問番号       */
 , CDBNRUI   VARCHAR2(10)                                /* 60  分類コード     */
 , KNRNGUI   VARCHAR2(200)                               /* 70  関連画面ID     */
 , TITLE     VARCHAR2(300)                               /* 80  タイトル       */
 , NAIYO     VARCHAR2(4000)                              /* 90  内容           */
 , SEQNO     NUMBER(7)         DEFAULT 0   NOT NULL      /* 100 表示順         */
 , TAG       VARCHAR2(200)                               /* 110 タグキーワード */
 , FGJ       VARCHAR2(1)       DEFAULT '1' NOT NULL      /* 120 状態フラグ     */
 , DYSET     VARCHAR2(14)                                /* 130 登録日時       */
 , PGSET     VARCHAR2(10)                                /* 140 作成PG         */
 , PGPSET    VARCHAR2(10)                                /* 150 作成親PG       */
 , USRSET    VARCHAR2(10)                                /* 160 作成社員       */
 , DYUPD     VARCHAR2(14)                                /* 170 更新日時       */
 , PGUPD     VARCHAR2(10)                                /* 180 更新PG         */
 , PGPUPD    VARCHAR2(10)                                /* 190 更新親PG       */
 , USRUPD    VARCHAR2(10)                                /* 200 更新者         */
)
TABLESPACE GETBL01
STORAGE( INITIAL 256K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE GE80S00 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GE80T00 
BEFORE INSERT ON GE80
FOR EACH ROW 
BEGIN 
SELECT GE80S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

