/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.resource;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;

public final class RoleMode {
    private static final Map<String, RoleMode> roleMap = Collections.synchronizedMap(new WeakHashMap(50));
    public static final byte FULL_MODE = 63;
    public static final byte M_MODE = 96;
    public static final byte P_MODE = 32;
    public static final byte R_MODE = 8;
    public static final byte W_MODE = 24;
    public static final byte D_MODE = 2;
    public static final byte U_MODE = 4;
    public static final byte F_MODE = 6;
    public static final byte E_MODE = 7;
    public static final String DEFAULT_MODE = "mwe";
    private final String roles;
    private final String rwmode;
    private final String[] roleArray;
    private final byte[] bitModes;
    private final boolean fullAccessFlag;
    private static final RoleMode FULL_ACCESS_ROLE_MODE_OBJ = new RoleMode();

    private RoleMode() {
        this.roles = "FullAccess";
        this.rwmode = DEFAULT_MODE;
        this.roleArray = null;
        this.bitModes = new byte[]{63};
        this.fullAccessFlag = true;
    }

    private RoleMode(String string, String string2) {
        this.roles = string;
        this.rwmode = string2;
        this.fullAccessFlag = "root".equals(string) || string == null || string.length() == 0;
        this.roleArray = StringUtil.csv2Array((String)string, (char)'|');
        this.bitModes = this.makeBitMode(this.roleArray, this.rwmode);
    }

    public static RoleMode newInstance(String string) {
        if (string == null || string.length() == 0) {
            return FULL_ACCESS_ROLE_MODE_OBJ;
        }
        return RoleMode.newInstance(string, DEFAULT_MODE);
    }

    public static RoleMode newInstance(String string, String string2) {
        if (string2 == null || string2.length() < 2) {
            String string3 = "RWMODE \u306e\u6841\u6570\u306f\u3001\uff12\u6841\u4ee5\u4e0a\u5fc5\u8981\u3067\u3059\u3002 roles [" + string + "]  mode [" + string2 + "]" + HybsSystem.CR;
            throw new HybsSystemException(string3);
        }
        if ((string == null || string.length() == 0) && ("mw".equals(string2) || DEFAULT_MODE.equals(string2))) {
            return FULL_ACCESS_ROLE_MODE_OBJ;
        }
        String string4 = string + string2;
        RoleMode roleMode = roleMap.get(string4);
        if (roleMode == null) {
            roleMode = new RoleMode(string, string2);
            roleMap.put(string4, roleMode);
        }
        return roleMode;
    }

    public String getRoles() {
        return this.roles;
    }

    public String getMode() {
        return this.rwmode;
    }

    public byte getAccessBitMode(RoleMode roleMode) {
        if (this.fullAccessFlag || roleMode.fullAccessFlag) {
            return (byte)(this.bitModes[0] & roleMode.bitModes[0]);
        }
        String[] stringArray = roleMode.roleArray;
        byte[] byArray = roleMode.bitModes;
        byte by = 0;
        for (int i = 0; i < this.roleArray.length; ++i) {
            for (int j = 0; j < stringArray.length; ++j) {
                if (!this.roleArray[i].equals(stringArray[j]) || (by = (byte)(by | (byte)(this.bitModes[i] & byArray[j]))) != 63) continue;
                return 63;
            }
        }
        return by;
    }

    public static boolean isMenu(byte by) {
        return (by & 0x60) > 0;
    }

    public static boolean isPulldown(byte by) {
        return (by & 0x60) == 32;
    }

    public static boolean isRead(byte by) {
        return (by & 8) > 0;
    }

    public static boolean isWrite(byte by) {
        return (by & 0x18) == 24;
    }

    public static boolean isAccess(byte by) {
        return (by & 0x18) > 0;
    }

    public static boolean isDownload(byte by) {
        return (by & 2) > 0;
    }

    public static boolean isUpload(byte by) {
        return (by & 4) > 0;
    }

    public static boolean isEdit(byte by) {
        return (by & 7) == 7;
    }

    private byte[] makeBitMode(String[] stringArray, String string) {
        byte[] byArray = null;
        byte by = this.bitMode(string);
        int n = stringArray.length;
        if (n == 0) {
            byArray = new byte[]{by};
        } else {
            byArray = new byte[n];
            for (int i = 0; i < n; ++i) {
                int n2;
                String string2 = null;
                String string3 = stringArray[i];
                int n3 = n2 = string3 != null ? string3.indexOf(40) : -1;
                if (n2 >= 0) {
                    string2 = string3.substring(n2 + 1, string3.length() - 1);
                    stringArray[i] = string3.substring(0, n2);
                }
                byArray[i] = (byte)(by & this.bitMode(string2));
            }
        }
        return byArray;
    }

    private byte bitMode(String string) {
        byte by = 0;
        if (string == null) {
            by = 63;
        } else {
            int n = string.length();
            block11: for (int i = 0; i < n; ++i) {
                switch (string.charAt(i)) {
                    case 'm': {
                        by = (byte)(by | 0x60);
                        continue block11;
                    }
                    case 'p': {
                        by = (byte)(by | 0x20);
                        continue block11;
                    }
                    case 'r': {
                        by = (byte)(by | 8);
                        continue block11;
                    }
                    case 'w': {
                        by = (byte)(by | 0x18);
                        continue block11;
                    }
                    case 'd': {
                        by = (byte)(by | 2);
                        continue block11;
                    }
                    case 'u': {
                        by = (byte)(by | 4);
                        continue block11;
                    }
                    case 'f': {
                        by = (byte)(by | 6);
                        continue block11;
                    }
                    case 'e': {
                        by = (byte)(by | 7);
                        continue block11;
                    }
                    case '-': {
                        continue block11;
                    }
                    default: {
                        String string2 = "RWMODE \u306b\u4e0d\u6b63\u306a\u8a18\u53f7\u304c\u4f7f\u7528\u3055\u308c\u3066\u3044\u307e\u3059\u3002 mrwdufe- \u306e\u307f\u3001\u4f7f\u7528\u53ef\u80fd\u3067\u3059\u3002 roles [" + this.roles + "]  mode [" + string + "]" + HybsSystem.CR;
                        throw new HybsSystemException(string2);
                    }
                }
            }
            if (n < 3) {
                by = (byte)(by | 7);
            }
            if ((by & 0x18) == 0) {
                by = 0;
            }
        }
        return by;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append("roles  : ").append(this.roles).append(HybsSystem.CR);
        stringBuilder.append("rwmode : ").append(this.rwmode).append(HybsSystem.CR);
        return stringBuilder.toString();
    }
}

