<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "DOC15"
	title	= "インクルードファイル検索"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>
<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />
<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID"
/>

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	<!-- 先頭のカラム名が、"WRITABLE" の場合、'true' or '1' で、書き込み許可が与えら,'2' でチェック済みになります。-->
	<jsp:text>
		select TAGNAME,SRC_FILE,count(*) as CNT
		from GF75
	</jsp:text>
	<og:where>
		<og:and value = "SYSTEM_ID  =  '{@SYSTEM_ID}'"  />
		<og:and value = "FGOMIT      = '0'"             />
		<og:and value = "FGJ         in  ('0','1')"     />
	</og:where>
	<jsp:text>
		group by TAGNAME,SRC_FILE
		order by TAGNAME,SRC_FILE
	</jsp:text>
</og:query>

<!-- ViewLinkTag は、指定のカラムにリンクを張ります。keysと、valsに、URLエンコードする値を設定します。 -->
<!-- 子要素の LinkTag は、単独でも使用できます。[カラム名] で、検索結果の各行毎の値を使用できます。 -->
<og:viewLink command="{@command}">
	<og:link column="SRC_FILE" href="result.jsp"
		keys="command,SYSTEM_ID,FGOMIT,SRC_FILE"
		vals="NEW,{@SYSTEM_ID},0,[SRC_FILE]" />
</og:viewLink>

<og:link href="result.jsp" keys="command,SYSTEM_ID" vals="NEW,{@SYSTEM_ID}" >{@LBL.UNGRPSRC}</og:link>
<br />

<og:view
	viewFormType = "HTMLTable"
	command    = "{@command}"
	checked    = "{@checked}"
	startNo    = "{@startNo}"
	pageSize   = "{@pageSize}"
/>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
