/**************************************************************************/
/* GF13 ( カレンダーファイル )                                            */
/*                                                                        */
/* Created : 2012/01/10 14:55:36                                          */
/**************************************************************************/
CREATE TABLE GF13 (
   CDJGS  VARCHAR2(10)                              /* 10  事業所コード */
 , YYYYMM VARCHAR2(6)                               /* 20  年月         */
 , DY1    VARCHAR2(1)                               /* 30  　１日       */
 , DY2    VARCHAR2(1)                               /* 40  　２日       */
 , DY3    VARCHAR2(1)                               /* 50  　３日       */
 , DY4    VARCHAR2(1)                               /* 60  　４日       */
 , DY5    VARCHAR2(1)                               /* 70  　５日       */
 , DY6    VARCHAR2(1)                               /* 80  　６日       */
 , DY7    VARCHAR2(1)                               /* 90  　７日       */
 , DY8    VARCHAR2(1)                               /* 100 　８日       */
 , DY9    VARCHAR2(1)                               /* 110 　９日       */
 , DY10   VARCHAR2(1)                               /* 120 １０日       */
 , DY11   VARCHAR2(1)                               /* 130 １１日       */
 , DY12   VARCHAR2(1)                               /* 140 １２日       */
 , DY13   VARCHAR2(1)                               /* 150 １３日       */
 , DY14   VARCHAR2(1)                               /* 160 １４日       */
 , DY15   VARCHAR2(1)                               /* 170 １５日       */
 , DY16   VARCHAR2(1)                               /* 180 １６日       */
 , DY17   VARCHAR2(1)                               /* 190 １７日       */
 , DY18   VARCHAR2(1)                               /* 200 １８日       */
 , DY19   VARCHAR2(1)                               /* 210 １９日       */
 , DY20   VARCHAR2(1)                               /* 220 ２０日       */
 , DY21   VARCHAR2(1)                               /* 230 ２１日       */
 , DY22   VARCHAR2(1)                               /* 240 ２２日       */
 , DY23   VARCHAR2(1)                               /* 250 ２３日       */
 , DY24   VARCHAR2(1)                               /* 260 ２４日       */
 , DY25   VARCHAR2(1)                               /* 270 ２５日       */
 , DY26   VARCHAR2(1)                               /* 280 ２６日       */
 , DY27   VARCHAR2(1)                               /* 290 ２７日       */
 , DY28   VARCHAR2(1)                               /* 300 ２８日       */
 , DY29   VARCHAR2(1)                               /* 310 ２９日       */
 , DY30   VARCHAR2(1)                               /* 320 ３０日       */
 , DY31   VARCHAR2(1)                               /* 330 ３１日       */
 , UNIQ   NUMBER(9)       DEFAULT 0   NOT NULL      /* 800 ユニークキー */
 , FGJ    VARCHAR2(1)     DEFAULT '1' NOT NULL      /* 810 状態フラグ   */
 , DYSET  VARCHAR2(14)                              /* 820 登録日時     */
 , PGSET  VARCHAR2(10)                              /* 830 作成PG       */
 , PGPSET VARCHAR2(10)                              /* 840 作成親PG     */
 , USRSET VARCHAR2(10)                              /* 850 作成社員     */
 , DYUPD  VARCHAR2(14)                              /* 860 更新日時     */
 , PGUPD  VARCHAR2(10)                              /* 870 更新PG       */
 , PGPUPD VARCHAR2(10)                              /* 880 更新親PG     */
 , USRUPD VARCHAR2(10)                              /* 890 更新者       */
)
TABLESPACE GETBL01
STORAGE( INITIAL 64K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE GF13S00 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GF13T00 
BEFORE INSERT ON GF13
FOR EACH ROW 
BEGIN 
SELECT GF13S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

