/**************************************************************************/
/* GF05 ( テーブルカラム定義 )                                            */
/*                                                                        */
/* Created : 2012/01/10 14:55:47                                          */
/**************************************************************************/
CREATE TABLE GF05 (
   SYSTEM_ID    VARCHAR(10)                  NOT NULL      /* 10  システムID   */
 , TBLSYU       VARCHAR(1)                   NOT NULL      /* 20  テーブル種別 */
 , TABLE_NAME   VARCHAR(50)                  NOT NULL      /* 30  テーブル名   */
 , CLM          VARCHAR(30)                  NOT NULL      /* 40  項目         */
 , SEQNO        NUMERIC(7)       DEFAULT 0   NOT NULL      /* 50  表示順       */
 , NAME_JA      VARCHAR(200)                               /* 60  名称         */
 , CLS_NAME     VARCHAR(10)                  NOT NULL      /* 70  DBクラス     */
 , USE_LENGTH   VARCHAR(9)       DEFAULT '0' NOT NULL      /* 80  使用桁数     */
 , DATA_DEFAULT VARCHAR(30)                                /* 90  初期値       */
 , NOT_NULL     VARCHAR(1)                                 /* 100 NOT NULL     */
 , FGCOM        VARCHAR(1)       DEFAULT '0' NOT NULL      /* 110 共通項目F    */
 , RENDERER     VARCHAR(10)                                /* 120 表示種別     */
 , EDITOR       VARCHAR(10)                                /* 130 編集種別     */
 , DBTYPE       VARCHAR(10)                                /* 140 文字種別     */
 , BIKO         VARCHAR(2000)                              /* 150 備考         */
 , CDKH         VARCHAR(1)                                 /* 160 改廃コード   */
 , UNIQ         BIGINT                       NOT NULL      /* 170 ユニークキー */
 , FGJ          VARCHAR(1)       DEFAULT '1' NOT NULL      /* 180 状態フラグ   */
 , DYSET        VARCHAR(14)                                /* 190 登録日時     */
 , PGSET        VARCHAR(10)                                /* 200 作成PG       */
 , PGPSET       VARCHAR(10)                                /* 210 作成親PG     */
 , USRSET       VARCHAR(10)                                /* 220 作成社員     */
 , DYUPD        VARCHAR(14)                                /* 230 更新日時     */
 , PGUPD        VARCHAR(10)                                /* 240 更新PG       */
 , PGPUPD       VARCHAR(10)                                /* 250 更新親PG     */
 , USRUPD       VARCHAR(10)                                /* 260 更新者       */
);

CREATE SEQUENCE GF05S00 ;


CREATE TRIGGER GF05T00 FOR GF05
  BEFORE INSERT 
  AS BEGIN 
    NEW.UNIQ = GEN_ID( GF05S00,1 );
  END; 


