/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.util;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opengion.fukurou.util.ModifyFileFilter;

public final class HybsFileFilter
implements FileFilter {
    private final List<FileFilter> list = new ArrayList<FileFilter>();
    private final boolean isUseDIR;

    public HybsFileFilter(boolean bl) {
        this.isUseDIR = bl;
    }

    public HybsFileFilter() {
        this(false);
    }

    @Override
    public boolean accept(File file) {
        if (file != null && (file.isFile() || this.isUseDIR)) {
            int n = this.list.size();
            for (int i = 0; i < n; ++i) {
                FileFilter fileFilter = this.list.get(i);
                if (fileFilter.accept(file)) continue;
                return false;
            }
        }
        return true;
    }

    public void addFileFilter(FileFilter fileFilter) {
        if (fileFilter != null) {
            this.list.add(fileFilter);
        }
    }

    public void startsWith(String string) {
        this.startsWith(string, false);
    }

    public void startsWith(String string, boolean bl) {
        if (string != null) {
            this.list.add(new StartsWithFilter(string, bl));
        }
    }

    public void endsWith(String string) {
        this.endsWith(string, false);
    }

    public void endsWith(String string, boolean bl) {
        if (string != null) {
            this.list.add(new EndsWithFilter(string, bl));
        }
    }

    public void instr(String string) {
        this.instr(string, false);
    }

    public void instr(String string, boolean bl) {
        if (string != null) {
            this.list.add(new InstrFilter(string, bl));
        }
    }

    public void fileEquals(String string) {
        this.fileEquals(string, false);
    }

    public void fileEquals(String string, boolean bl) {
        if (string != null) {
            this.list.add(new EqualsFilter(string, bl));
        }
    }

    public void matches(String string) {
        this.matches(string, false);
    }

    public void matches(String string, boolean bl) {
        if (string != null) {
            this.list.add(new MatchesFilter(string, bl));
        }
    }

    public void lastModified(String string) {
        if (string != null) {
            this.list.add(new ModifyFileFilter(string));
        }
    }

    public void isLarger(int n) {
        if (n >= 0) {
            this.list.add(new IsLargerFilter(n));
        }
    }

    public void isSmaller(int n) {
        if (n >= 0) {
            this.list.add(new IsSmallerFilter(n));
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.list.size();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("no[").append(i).append("]=");
            stringBuilder.append(this.list.get(i)).append("\n");
        }
        return stringBuilder.toString();
    }

    private static class IsSmallerFilter
    implements FileFilter {
        private final long size;

        IsSmallerFilter(int n) {
            this.size = n;
        }

        @Override
        public boolean accept(File file) {
            return file.length() < this.size;
        }
    }

    private static class IsLargerFilter
    implements FileFilter {
        private final long size;

        IsLargerFilter(int n) {
            this.size = n;
        }

        @Override
        public boolean accept(File file) {
            return file.length() >= this.size;
        }
    }

    private static class MatchesFilter
    implements FileFilter {
        private final Pattern pattern;
        private final boolean rvse;

        MatchesFilter(String string, boolean bl) {
            this.pattern = Pattern.compile(string, 2);
            this.rvse = bl;
        }

        @Override
        public boolean accept(File file) {
            Matcher matcher = this.pattern.matcher(file.getName());
            if (matcher.find()) {
                return !this.rvse;
            }
            return this.rvse;
        }
    }

    private static class EqualsFilter
    implements FileFilter {
        private final String[] eqstr;
        private final int cnt;
        private final boolean rvse;

        EqualsFilter(String string, boolean bl) {
            this.rvse = bl;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
            this.cnt = stringTokenizer.countTokens();
            this.eqstr = new String[this.cnt];
            for (int i = 0; i < this.cnt; ++i) {
                this.eqstr[i] = stringTokenizer.nextToken();
            }
        }

        @Override
        public boolean accept(File file) {
            for (int i = 0; i < this.cnt; ++i) {
                if (!file.getName().equalsIgnoreCase(this.eqstr[i])) continue;
                return !this.rvse;
            }
            return this.rvse;
        }
    }

    private static class InstrFilter
    implements FileFilter {
        private final String[] instr;
        private final int cnt;
        private final boolean rvse;

        InstrFilter(String string, boolean bl) {
            this.rvse = bl;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
            this.cnt = stringTokenizer.countTokens();
            this.instr = new String[this.cnt];
            for (int i = 0; i < this.cnt; ++i) {
                this.instr[i] = stringTokenizer.nextToken();
            }
        }

        @Override
        public boolean accept(File file) {
            for (int i = 0; i < this.cnt; ++i) {
                if (file.getName().indexOf(this.instr[i]) < 0) continue;
                return !this.rvse;
            }
            return this.rvse;
        }
    }

    private static class EndsWithFilter
    implements FileFilter {
        private final String[] sfix;
        private final int cnt;
        private final boolean rvse;

        EndsWithFilter(String string, boolean bl) {
            this.rvse = bl;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
            this.cnt = stringTokenizer.countTokens();
            this.sfix = new String[this.cnt];
            for (int i = 0; i < this.cnt; ++i) {
                this.sfix[i] = stringTokenizer.nextToken();
            }
        }

        @Override
        public boolean accept(File file) {
            for (int i = 0; i < this.cnt; ++i) {
                if (!file.getName().endsWith(this.sfix[i])) continue;
                return !this.rvse;
            }
            return this.rvse;
        }
    }

    private static class StartsWithFilter
    implements FileFilter {
        private final String[] pfix;
        private final int cnt;
        private final boolean rvse;

        StartsWithFilter(String string, boolean bl) {
            this.rvse = bl;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
            this.cnt = stringTokenizer.countTokens();
            this.pfix = new String[this.cnt];
            for (int i = 0; i < this.cnt; ++i) {
                this.pfix[i] = stringTokenizer.nextToken();
            }
        }

        @Override
        public boolean accept(File file) {
            for (int i = 0; i < this.cnt; ++i) {
                if (!file.getName().startsWith(this.pfix[i])) continue;
                return !this.rvse;
            }
            return this.rvse;
        }
    }
}

