/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.io.File;
import org.opengion.fukurou.db.ConnectionFactory;
import org.opengion.fukurou.db.DatabaseConfig;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.db.DBTableModelUtil;
import org.opengion.hayabusa.taglib.CommonTagSupport;

public class DBConfigEditorTag
extends CommonTagSupport {
    private static final String VERSION = "5.1.9.0 (2010/08/01)";
    private static final long serialVersionUID = 5160L;
    private transient DBTableModel table = null;
    private String command = "GET";
    private String type = "DBID";
    private String xmlFile = null;

    @Override
    public int doStartTag() {
        this.startQueryTransaction("h_tblmdl");
        return 0;
    }

    @Override
    public int doEndTag() {
        this.debugPrint();
        DatabaseConfig databaseConfig = null;
        if (this.xmlFile == null) {
            databaseConfig = new DatabaseConfig();
        } else {
            if (!new File(this.xmlFile).exists()) {
                throw new HybsSystemException("\u7de8\u96c6\u5bfe\u8c61\u306eDBConfig.xml\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002File=[" + this.xmlFile + "]");
            }
            databaseConfig = new DatabaseConfig(this.xmlFile);
        }
        String[] stringArray = null;
        if ("DBID".equals(this.type)) {
            stringArray = DatabaseConfig.getDbidInfoKeys();
        } else if ("CLASS".equals(this.type)) {
            stringArray = new String[]{DatabaseConfig.getDriverKey()};
        }
        if ("GET".equals(this.command)) {
            this.table = this.getDBConfig(databaseConfig, stringArray);
            if (this.table != null && !this.commitTableObject("h_tblmdl", this.table)) {
                this.jspPrint("QueryTag Query\u51e6\u7406\u304c\u5272\u308a\u8fbc\u307e\u308c\u307e\u3057\u305f\u3002DBTableModel \u306f\u767b\u9332\u3057\u307e\u305b\u3093\u3002");
                return 5;
            }
        } else if ("SET".equals(this.command)) {
            this.setDBConfig(databaseConfig, stringArray);
            if (this.xmlFile == null) {
                ConnectionFactory.realClose();
                ConnectionFactory.init((String)HybsSystem.getContextName(), null);
            }
        }
        return 6;
    }

    private DBTableModel getDBConfig(DatabaseConfig databaseConfig, String[] stringArray) {
        String[][] stringArray2 = null;
        if ("DBID".equals(this.type)) {
            stringArray2 = databaseConfig.getDbidInfo();
        } else if ("CLASS".equals(this.type)) {
            String[] stringArray3 = databaseConfig.getDriverList();
            stringArray2 = new String[stringArray3.length][1];
            for (int i = 0; i < stringArray3.length; ++i) {
                stringArray2[i][0] = stringArray3[i];
            }
        }
        return DBTableModelUtil.makeDBTable(stringArray, stringArray2, this.getResource());
    }

    private void setDBConfig(DatabaseConfig databaseConfig, String[] stringArray) {
        this.table = (DBTableModel)this.getObject("h_tblmdl");
        String string = StringUtil.array2csv((String[])this.table.getNames());
        if (!StringUtil.array2csv((String[])stringArray).equals(string)) {
            throw new RuntimeException("DBTableModel\u306e\u30ad\u30fc\u304c\u4e0d\u6b63\u3067\u3059");
        }
        int n = this.table.getRowCount();
        String[][] stringArray2 = new String[n][stringArray.length];
        for (int i = 0; i < n; ++i) {
            stringArray2[i] = (String[])this.table.getValues(i);
        }
        if ("DBID".equals(this.type)) {
            databaseConfig.setDbidInfo(stringArray2);
        } else if ("CLASS".equals(this.type)) {
            String[] stringArray3 = new String[stringArray2.length];
            for (int i = 0; i < stringArray2.length; ++i) {
                stringArray3[i] = stringArray2[i][0];
            }
            databaseConfig.setDriverList(stringArray3);
        }
    }

    @Override
    protected void release2() {
        super.release2();
        this.command = "GET";
        this.type = "DBID";
        this.xmlFile = null;
    }

    public void setCommand(String string) {
        this.command = StringUtil.nval((String)this.getRequestParameter(string), (String)this.command);
    }

    public void setType(String string) {
        this.type = StringUtil.nval((String)this.getRequestParameter(string), (String)this.type);
    }

    public void setXmlFile(String string) {
        this.xmlFile = StringUtil.nval((String)this.getRequestParameter(string), (String)this.xmlFile);
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("command", (Object)this.command).println("type", (Object)this.type).println("xmlFile", (Object)this.xmlFile).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }
}

