/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.table;

/**
 * <p>TableFilter_INDEX_FIREBIRD は、TableUpda インターフェースを継承した、DBTableModel 処理用の
 * 実装クラスです。とくに、FireBird用のインデックス作成スクリプトを作成します。<br />
 *
 * ここでは、テーブル一覧の検索結果より、GF07 のインデックスカラム定義テーブルから
 * 必要な情報を取得し、テーブル作成スクリプトを作成します。
 * 出力ファイルは、テーブル名＋"I.sql" という命名規則で作成します。
 * 検索では、(SYSTEM_ID,TBLSYU,TABLE_NAME,NAME_JA,TABLESPACE_NAME,INITIAL_EXTENT,NEXT_EXTENT,COMMENTS)
 * の項目を取得する必要があります。
 *
 * @og.rev 5.1.1.0 (2009/12/01) 新規作成
 *
 * @version  0.9.0  2000/10/17
 * @author   Kazuhiko Hasegawa
 * @since    JDK1.1,
 */
public class TableFilter_INDEX_FIREBIRD extends TableFilter_INDEX {
	//* このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "5.1.1.0 (2009/12/01)" ;

	/**
	 * インデックス作成の処理を実行します。
	 *
	 * @param   clmNo int[]
	 * @param   data  String[]
	 * @param   clms String
	 * @return String インデックス作成
	 */
	protected String makeLineList( final int[] clmNo,final String[] data,final String clms ) {
		String tableName = data[clmNo[TABLE_NAME]];
		String indexName = data[clmNo[INDEX_NAME]];
		String idxtype   = data[clmNo[INDTYPE]];

		StringBuilder buf = new StringBuilder();

		if( isXml ) { buf.append( EXEC_START_TAG ).append( CR ); }

		if( "1".equals( idxtype ) ) {	// ユニークキー
			buf.append( "CREATE UNIQUE INDEX " ).append( indexName ).append( " ON " );
			buf.append( tableName ).append( "( " ).append( clms );
			buf.append( " )" );
		}
		else {
			buf.append( "CREATE INDEX " ).append( indexName ).append( " ON " );
			buf.append( tableName ).append( "( " ).append( clms );
			buf.append( " )" );
		}

		return buf.toString();
	}

	/**
	 * 定義の最後の部分の処理を実行します。
	 *
	 * @param   clmNo int[]
	 * @param   data  String[]
	 * @return String 定義の最後の部分
	 */
	protected String makeEndLine( final int[] clmNo,final String[] data ) {
//		return ";";
		return ( isXml ? EXEC_END_TAG : ";" );
	}
}
