/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.column;

import org.opengion.hayabusa.db.AbstractRenderer;
import org.opengion.hayabusa.db.CellRenderer;
import org.opengion.hayabusa.db.DBColumn;

/**
 * TMSTMP レンデラーは、日付ネイティブのカラムのデータから、数字部分だけをピックアップし、
 * 日時（年/月/日 時:分:秒）表示する場合に使用するクラスです。
 * 数字以外は、各データベースによって、まちまちなので、'/',':','-',' ' を削除します。
 * なお、並び順は、必須に、YYYYMMDDHHMISS の順番とし、January 8 などの形式や、
 * 04:05 AM 、1/8/1999 などの形式は受け付けることは出来ません。
 * あくまで、先頭から 数字を順次取得し、YYYYMMDDHHMISS 形式に当てはめていきます。
 *
 * カラムの表示に必要な属性は, DBColumn オブジェクト より取り出します。
 * このクラスは、DBColumn オブジェクト毎に１つ作成されます。
 *
 * @og.group データ表示
 *
 * @og.rev 5.3.10.0 (2011/10/01) synchronized を、削除します。
 *
 * @version  4.0
 * @author   Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
public class Renderer_TMSTMP extends AbstractRenderer {
	//* このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "5.3.10.0 (2011/10/01)" ;

	private static final CellRenderer dbCell = new Renderer_TMSTMP() ;

	/**
	 * 各オブジェクトから自分のインスタンスを返します。
	 * 自分自身をキャッシュするのか、新たに作成するのかは、各サブクラスの実装に
	 * まかされます。
	 *
	 * @param   clm DBColumn オブジェクト
	 * @return  CellRenderer オブジェクト
	 */
	public CellRenderer newInstance( final DBColumn clm ) {
		return dbCell;
	}

	/**
	 * データの表示用文字列を返します。
	 *
	 * @param   value String
	 * @return  データの表示用文字列
	 */
	public String getValue( final String value ) {
		final String rtn;

		if( value == null || value.length() == 0 ) {
			rtn = "";
		}
		else {
			StringBuilder buf = new StringBuilder();
			int cnt = 0;
			for( int i=0; i<value.length(); i++ ) {
				char ch = value.charAt(i);
				if( ch >= '0' && ch <= '9' ) {
					buf.append( ch );
					cnt++;
					if( cnt == 4 || cnt == 6 ) {
						buf.append( '/' );
					}
					if( cnt == 8 ) {
						buf.append( ' ' );
					}
					if( cnt == 10 || cnt == 12 ) {
						buf.append( ':' );
					}
					if( cnt == 14 ) { break; }
				}
			}
			rtn = buf.toString();
		}

		return rtn;
	}
}
