/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.fukurou.transfer;



/**
 * 伝送の定義情報を管理するためのデータクラスです。
 *
 * @og.group 伝送システム
 *
 * @version  5.0
 * @author   Hiroki.Nakamura
 * @since    JDK1.6
 */
public class TransferConfig {

	private final String	kbRead;		// 読取方法
	private final String	readObj;	// 読取対象
	private final String	readPrm;	// 読取パラーメーター
	private final String	kbExec;		// 実行方法
	private final String	execDbid;	// 実行DB接続先ID
	private final String	execObj;	// 実行対象
	private final String	execPrm;	// 実行パラメーター
	private final String	errorSendto;// エラー送信先
	private final String	hfrom;		// 送り元ホストコード
	private final String	proxyHost;	// HTTP接続時のプロキシホスト
	private final int		proxyPort;	// HTTP接続時のプロキシポート

	static final String HTTP_AUTH_USER_PASS = "RMCN_USR:RMCN_PASS"; // HTTT接続時のBASIC認証のユーザーID:パスワード

	/**
	 * コンストラクタです。
	 * 
	 * @param kbRead 読取方法
	 * @param readObj 読取対象
	 * @param readPrm 読取パラーメーター
	 * @param kbExec 実行方法
	 * @param execDbid 実行DB接続先ID
	 * @param execObj 実行対象
	 * @param execPrm 実行パラメーター
	 * @param errorSendto エラー送信先
	 * @param hfrom 送り元ホストコード
	 * @param proxyHost プロキシホスト
	 * @param proxyPort プロキシポート
	 */
	public TransferConfig(
			final String kbRead, final String readObj, final String readPrm
			,final String kbExec, final String execDbid, final String execObj, final String execPrm
			,final String errorSendto, final String hfrom, final String proxyHost, final int proxyPort ) {
				this.kbRead		= kbRead;
				this.readObj	= readObj;
				this.readPrm	= readPrm;
				this.kbExec		= kbExec;
				this.execDbid	= execDbid;
				this.execObj	= execObj;
				this.execPrm	= execPrm;
				this.errorSendto= errorSendto;
				this.hfrom		= hfrom;
				this.proxyHost	= proxyHost;
				this.proxyPort	= proxyPort;
	}

	/**
	 * 読取方法を返します。
	 * 
	 * @return 読取対象
	 */
	public String getKbRead() {
		return kbRead;
	}

	/**
	 * 読取対象を返します。
	 * 
	 * @return 読取対象
	 */
	public String getReadObj() {
		return readObj;
	}

	/**
	 * 読取パラーメーターを返します。
	 * 
	 * @return 読取パラーメーター
	 */
	public String getReadPrm() {
		return readPrm;
	}

	/**
	 * 実行方法を返します。
	 * 
	 * @return 実行方法
	 */
	public String getKbExec() {
		return kbExec;
	}

	/**
	 * 実行DB接続先IDを返します。
	 * 
	 * @return 実行DB接続先ID
	 */
	public String getExecDbid() {
		return execDbid;
	}

	/**
	 * 実行対象を返します。
	 * 
	 * @return 実行対象
	 */
	public String getExecObj() {
		return execObj;
	}

	/**
	 * 実行パラメーターを返します。
	 * 
	 * @return 実行パラメーター
	 */
	public String getExecPrm() {
		return execPrm;
	}

	/**
	 * エラー送信先を返します。
	 * 
	 * @return エラー送信先
	 */
	public String getErrorSendto() {
		return errorSendto;
	}

	/**
	 * 送り元ホストコードを返します。
	 * 
	 * @return 送り元ホストコード
	 */
	public String getHfrom() {
		return hfrom;
	}

	/**
	 * プロキシホスト名を返します。
	 * 
	 * @return プロキシホスト名
	 */
	public String getProxyHost() {
		return proxyHost;
	}

	/**
	 * プロキシポート番号を返します。
	 * 
	 * @return プロキシポート番号
	 */
	public int getProxyPort() {
		return proxyPort;
	}

	/**
	 * このオブジェクトの文字列表現を返します
	 * 
	 * @return 文字列表現
	 */
	public String toString() {
		StringBuilder buf = new StringBuilder();
		buf.append( "kbRead=" ).append( kbRead )
			.append( "readObj=" ).append( readObj )
			.append( ",readPrm=" ).append( readPrm )
			.append( ",kbExec=" ).append( kbExec )
			.append( ",execDbid=" ).append( execDbid )
			.append( ",execObj=" ).append( execObj )
			.append( ",execPrm=" ).append( execPrm )
			.append( ",errorSendto=" ).append( errorSendto )
			.append( ",hfrom=" ).append( hfrom )
			.append( ",proxyHost=" ).append( proxyHost )
			.append( ",proxyPort=" ).append( proxyPort );
		return buf.toString();
	}
}
