/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.fukurou.process;

import java.sql.Connection;
import java.util.Set ;

/**
 * ParamProcess インターフェース は、AbstractProcess を実行する上で必要となる
 * 各種パラメータを設定します。
 * 特に、データベース接続を使用する場合は、このインターフェースを使用して、
 * データベースコネクションを取得する必要があります。
 *
 * @og.rev 5.3.4.0 (2011/04/01) bulkData 関係のメソッドを追加
 * @version  4.0
 * @author   Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
public interface ParamProcess extends HybsProcess {

	/**
	 * 指定の DBID に対する コネクションを返します。
	 *
	 * @param	key	String DBID
	 * @return	Connection コネクション
	 */
	Connection getConnection( final String key );

	/**
	 * 検索した結果が設定された Set オブジェクトを設定します。
	 *
	 * @og.rev 5.3.4.0 (2011/04/01) 新規追加
	 *
	 * @param	bulkData	Set<String> 検索した結果が設定された Set オブジェクト
	 */
	void setBulkData( final Set<String> bulkData );

	/**
	 * 検索した結果が設定された Set オブジェクトを返します。
	 *
	 * @og.rev 5.3.4.0 (2011/04/01) 新規追加
	 *
	 * @return	Set<String> 検索した結果が設定された Set オブジェクト
	 */
	Set<String> getBulkData();
}
