<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF6340"
	title	= "マウスオーバー"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>
<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID,LANG,CLM,NAME_JA,LABEL_NAME"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	<!-- 先頭のカラム名が、"WRITABLE" の場合、'true' or '1' で、書き込み許可が与えら,'2' でチェック済みになります。-->
	<jsp:text>
		select CASE KBSAKU WHEN '3' THEN '2' ELSE KBSAKU END AS WRITABLE,
				CLM,NAME_JA,LABEL_NAME,KBSAKU,SYSTEM_ID,LANG,COMMENTS,FGJ
		from GF41
	</jsp:text>
	<og:where>
		<og:and value = "FGJ         in  ('0','1')"         />
		<og:and value = "SYSTEM_ID  =  '{@SYSTEM_ID}'"  />
		<og:and value = "LANG        = '{@LANG}'"           />
		<og:and value = "CLM         like '{@CLM}%'"        />
		<og:and value = "NAME_JA     like '{@NAME_JA}%'"    />
		<og:and value = "LABEL_NAME  like '{@LABEL_NAME}%'" />
		<og:and value = "KBSAKU      =    '{@KBSAKU}'"      />
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "SYSTEM_ID,CLM,LANG" />
</og:query>

<!-- ColumnEditorTag は、指定のカラム属性を設定しなおします。 以下は、must属性を true にしています。 -->
<og:columnEditor column="SYSTEM_ID" must="true" />
<og:columnEditor column="LANG"      must="true" />
<og:columnEditor column="CLM"       must="true" />

<!-- ViewLinkTag は、指定のカラムにリンクを張ります。keysと、valsに、URLエンコードする値を設定します。 -->
<!-- 子要素の LinkTag は、単独でも使用できます。[カラム名] で、検索結果の各行毎の値を使用できます。 -->
<og:viewLink command="{@command}">
	<og:link column="CLM" gamenId="GF9500" href="index.jsp" target="CONTENTS" title="[NAME_JA]"
		keys="command,SYSTEM_ID,LANG,CLM,KBSAKU,IMAGE"
		vals="NEW,[SYSTEM_ID],[LANG],[CLM],[KBSAKU],true" />
	<!-- LinkTag のuseGamenId属性 を "false" に設定すると、GAMENID,BACK_GAMENIDなどのリクエスト情報が付加されません。-->
	<og:link column="LABEL_NAME" target="_blank" useGamenId="false" onLink="[KBSAKU]" markList="3"
			  href="{@SYS.JSP}/customImage/[CLM].xv3"  />
</og:viewLink>

<!-- ViewMarkerTag は、指定のカラムをマーキングします。 -->
<og:viewMarker command="{@command}">
	<og:columnMarker column="NAME_JA" onMark="[KBSAKU]" >
		<span style="background-color:#ccff00">[NAME_JA]</span>
	</og:columnMarker>
</og:viewMarker>

<!-- formタグでリクエストフィールドを囲います。oneClick()関数は、２重押し防止JavaScriptです。 -->
<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">

<!-- 複写、変更、削除ボタンを作成します。value属性+.jspの画面に制御が移ります。 -->
<!-- このとき、command=(value属性の値の大文字)が設定されます。 command属性で設定しなおすことも出来ます。-->
<og:writeCheck>
	<og:submit  value="copy"     lbl="COPY"    accesskey="C" title="MSG0045" />
	<og:submit  value="modify"   lbl="MODIFY"  accesskey="M" title="MSG0046" />
	<og:submit  value="delete"   lbl="DELETE"  accesskey="D" title="MSG0047" />
<br />
</og:writeCheck>

<!-- DB検索結果を表示させます。 -->
<!-- checked="true" で、チェック済みの状態で表示できます。 -->
<!-- selectedType="checkbox(デフォルト)/radio/hidden" から、選べます。-->
<og:view
	viewFormType = "HTMLCustomTable"
	command    = "{@command}"
	noDisplay  = "FGJ"
	checked    = "{@checked}"
	startNo    = "{@startNo}"
	pageSize   = "{@pageSize}"
	rowspan    = "1"
>

	<og:thead rowspan="1">
		<tr><td>[CLM]</td><td>[NAME_JA]</td><td>[LABEL_NAME]</td>
			<td>[KBSAKU]</td><td>[SYSTEM_ID]</td><td>[LANG]</td>
		</tr>
	</og:thead>

	<og:tbody rowspan="1" usableKey="WRITABLE" usableList="0" >
		<tr><td>[CLM]</td><td title="[COMMENTS]">[NAME_JA]</td><td>[LABEL_NAME]</td>
			<td>[KBSAKU]</td><td>[SYSTEM_ID]</td><td>[LANG]</td>
		</tr>
	</og:tbody>

	<og:tbody rowspan="1" usableKey="WRITABLE" usableList="1" >
		<tr><td>[CLM]</td><td title="[COMMENTS]">[NAME_JA]</td><td>[LABEL_NAME]</td>
			<td>[KBSAKU]</td><td>[SYSTEM_ID]</td><td>[LANG]</td>
		</tr>
	</og:tbody>

	<og:tbody rowspan="1" usableKey="WRITABLE" usableList="2" >
		<tr><td>[CLM]</td><td title="[COMMENTS]">[NAME_JA]</td><td>[LABEL_NAME]</td>
			<td>[KBSAKU]</td><td>[SYSTEM_ID]</td><td>[LANG]</td>
		</tr>
	</og:tbody>

</og:view>
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
