<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF6080"
	title	= "テーブル回転・結合"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<og:text>[マスター表]</og:text>
<og:query command="{@command}" tableId="master" scope="request">
	<jsp:text>
		select deptno,dname from dept
	</jsp:text>
	<og:where>
		<og:and value="deptno like '{@DEPTNO}%'" />
	</og:where>
</og:query>
<og:view tableId="master" useScrollBar = "false" scope="request"/>

<og:text>[スレーブ表]</og:text>
<og:query command="{@command}" tableId="slave" scope="request">
	<jsp:text>
		select deptno,ename,empno from emp
	</jsp:text>
	<og:where>
		<og:and value="deptno like '{@DEPTNO}%'" />
		<og:and value="ename like '{@ENAME}%'" />
		<og:and value="empno like '{@EMPNO}%'" />
	</og:where>
	<jsp:text>
		order by deptno,empno
	</jsp:text>
</og:query>
<og:view tableId="slave" useScrollBar="false" scope="request"/>

<og:text>[スレーブ表・変換後]</og:text>
<div style="display: none;">
<og:view
	viewFormType = "HTMLCrossTable"
	noDisplay  = "empno"
	useParam   = "true"
	useScrollBar = "false"
	scope="request"
	tableId = "slave">
	<og:crossParam
		cubeXColumn		= "deptno"
		cubeYColumn		= "ename"
		saveTableId		= "slave2"
		useHeaderColumn	= "true"
	/>
</og:view>
</div>
<og:view useScrollBar="false" noDisplay="empno" tableId="slave2" scope="request"/>

<og:text>[結合対象のカラム一覧]</og:text>
<br />
<og:value command="SQL" action="ROW_APPEND">
	<jsp:text>
		select ename enamelist from emp
	</jsp:text>
	<og:where>
		<og:and value="deptno like '{@DEPTNO}%'" />
		<og:and value="ename like '{@ENAME}%'" />
		<og:and value="empno like '{@EMPNO}%'" />
	</og:where>
	<jsp:text>
		group by deptno,empno,ename
		order by deptno,empno,ename
	</jsp:text>
</og:value>
<og:text>{@ENAMELIST}</og:text>

<br />
<og:text>[結合後の表]</og:text>
<br />
<og:tableMerge
	action     = "UNION_CLM"
	masterTableId = "master"
	masterScope = "request"
	masterKeys = "deptno,dname"
	slaveTableId = "slave2"
	slaveScope = "request"
	slaveKeys  = "deptno"
	unionClms  = "{@ENAMELIST}"
/>
<og:view useScrollBar = "false" />

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
