<!-- PostgreSQL  -->
<og:equals val1="{@DBF.NAME}" val2="POSTGRES">
  <og:query command="NEW" dbid="{@DBID}" maxRowCount="100000">
	select case c.relkind when 't' then 'TRIGGER'
						  when 'S' then 'SEQUENCE'
						  when 'r' then 'TABLE'
						  when 'i' then 'INDEX'
						  when 'v' then 'VIEW'
						  else 'NV' end as OBJECT_TYPE ,
			c.relname as OBJECT_NAME ,
			c.relname as NAME_JA ,
			'VALID' AS STTS
	FROM pg_class c LEFT join pg_user u 
	ON c.relowner = u.usesysid
	where u.usename != 'postgres'
	and   c.relkind  not in ( 'r','i','v' )		-- TABLE,INDEX,VIEW 
	<og:where startKey="and">
		<og:and value="( 'TRIGGER' = '{@OBJ_TYPE2}' and c.relkind = 't' ) or ( 'FUNCTION' = '{@OBJ_TYPE2}' and c.relkind = 'S')"	/>
	</og:where>
		order by OBJECT_TYPE,OBJECT_NAME
  </og:query>
</og:equals>

<!-- ORACLE  -->
<og:equals val1="{@DBF.NAME}" val2="ORACLE">
  <og:query command="NEW" dbid="{@DBID}" maxRowCount="100000">
	select OBJECT_TYPE,OBJECT_NAME,OBJECT_NAME AS NAME_JA,STATUS AS STTS
	from USER_OBJECTS
	where INSTR(OBJECT_NAME,'$') < 1
	and   OBJECT_TYPE  not in ( 'TABLE','INDEX','VIEW' )
	<og:where startKey="and">
		<og:and value="OBJECT_TYPE =	'{@OBJ_TYPE2}'"	/>
	</og:where>
		order by OBJECT_TYPE,OBJECT_NAME
  </og:query>
</og:equals>
