<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head useGantt="true"  headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GANTT09"
	title	= "ガントチャート(タスク埋メ)"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>
<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
	columns   = "PRJCODE,RESOURCE_ID,DYFROM,DYTO"
	nullCheck = "PRJCODE,DYFROM,DYTO"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- 取込み元：ﾘｿｰｽﾌｧｲﾙ -->
<og:query
	command    = "{@command}"
	names	   = "PRJCODE,RESOURCE_ID,DYFROM,DYTO,USER.IDNO"
	queryType  = "JDBCErrMsg" >
	<jsp:text>
		{ call GANTT_PKG.GANTTQUERY(?,?,?,?) }
	</jsp:text>
</og:query>

<script type="text/javascript" src="taskinfo.js" ><!-- --></script>

<!-- formタグでリクエストフィールドを囲います。oneClick()関数は、２重押し防止JavaScriptです。 -->
<form name="fOperate" onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">
<table summary="layout" >
<tr>
	<td></td>
	<td><og:message lbl="PRJCODE"		 /></td>
	<td><og:message lbl="TASK_ID"		 /></td>
	<td><og:message lbl="RESOURCE_ID"	 /></td>
	<td><og:message lbl="DYSTART"		 /></td>
	<td><og:message lbl="DYDELAY"		 /></td>
	<td><og:message lbl="DURATION"		 /></td>
	<td><og:message lbl="NAME_JA"			 /></td>
</tr>
<tr>
	<td><b>From:</b>
	</td>
	<td>
		<og:select name="PRJCODE" must="true" td="false">
			<og:option value="" lbl="" />
			<og:queryOption>
				<jsp:text>
					select PRJCODE, NAME_JA from GF62
					where fgj in ('0','1')
					order by PRJCODE
				</jsp:text>
			</og:queryOption>
		</og:select>
	</td>
	<td><og:column name="TASK_ID" 		td="false" must="true" size="10" /></td>
	<td><og:column name="RESOURCE_ID"	td="false" must="true" 			 /></td>
	<td><og:column name="DYSTART"		td="false" must="true" size="9" value="{@EMPTY}" /></td>
	<td><og:column name="DYDELAY"		td="false" must="false"			 /></td>
	<td><og:column name="DURATION"		td="false" must="true"			 /></td>
	<td><og:column name="NAME_JA"			td="false" must="false"			 /></td>
</tr>
<tr>
	<td><b>To:</b>
	</td>
	<td>
		<!-- onChange="renew('query.jsp','QUERY'); "  -->
		<og:select name="PRJCODE3" td="false" >
			<og:option value="" lbl="" />
			<og:queryOption>
				<jsp:text>
					select PRJCODE,NAME_JA from GF62
					where fgj in ('0','1')
					order by PRJCODE
				</jsp:text>
			</og:queryOption>
		</og:select>
	</td>
	<td><og:column name="TASK_ID3"		td="false" must="false" size="10" /></td>
	<td><og:column name="RESOURCE_ID3" td="false" must="false"			  /></td>
	<td><og:column name="DYSTART3"		td="false" must="false" size="9"  /></td>
	<td><og:column name="DYDELAY3"		td="false" must="false"			  /></td>
	<td><og:column name="DURATION3"	td="false" must="false"			  /></td>
	<td><og:column name="NAME_JA3"		td="false" must="false"			  /></td>
</tr>
</table>

<!-- 複写、変更、削除ボタンを作成します。value属性+.jspの画面に制御が移ります。 -->
<!-- このとき、command=(value属性の値の大文字)が設定されます。 command属性で設定しなおすことも出来ます。-->
<og:writeCheck>
	<og:submit  value="entry"   lbl="INSERT"   accesskey="I" command="NEW" onClick="this.form.CDKH.value='I'"/>
	<og:submit  value="entry"   lbl="MODIFY"   accesskey="M" command="NEW" onClick="this.form.CDKH.value='M'"/>
	<og:submit  value="entry"   lbl="DELETE"   accesskey="D" command="NEW" onClick="this.form.CDKH.value='D'"/>
	<og:message lbl="SPACE" />
	<og:submit  value="entry"   lbl="EXCHANGE" accesskey="E" command="NEW" onClick="this.form.CDKH.value='E'"/>
	<og:submit  value="entry"   lbl="CLEAR"    accesskey="L" command="NEW" onClick="ClearForm();return false;" />
	<og:message lbl="SPACE" />
	<og:submit  value="entry"   lbl="SETTLE"   accesskey="S" command="NEW" onClick="this.form.CDKH.value='S'"/>
	<og:link href="resultPrint.jsp" keys="command" vals="VIEW" >Print</og:link>
</og:writeCheck>
<og:hidden name="CDKH"             value=""               />
<og:hidden name="OLDPRJCODE"       value="{@PRJCODE}"     />
<og:hidden name="OLDRESOURCE_ID"   value="{@RESOURCE_ID}" />
<og:hidden name="OLDDYFROM"        value="{@DYFROM}"      />
<og:hidden name="OLDDYTO"          value="{@DYTO}"        />
</form>
<script type="text/javascript">
	window.onload 	=	function(evt) {
							ClearForm(evt);
							heightReset(evt);
							ganttResize(evt);
						};
	window.onresize	=	function(evt) {
							heightReset(evt);
							ganttResize(evt);
						};
</script>

<table id="GantBody" border="0" cellpadding="0" cellspacing="0" frame="box" rules="all" style="margin:0px;padding:0px;">
  <tr style="margin:0px;padding:0px;">
    <td valign="top" style="margin:0px;padding:0px;" >
      <div id="X1" style="height:360px; width:130; overflow-x:hidden; overflow-y:hidden; overflow:hidden;" >
        <jsp:directive.include file="viewX1.jsp" />
      </div>
    </td>
    <td  valign="top" style="margin:0px;padding:0px;">
      <div id="X2" style="height:380px; width:670px; overflow-x:auto; overflow-y:auto; overflow:auto;"
                   onscroll="document.all.X1.scrollTop = document.all.X2.scrollTop;" >
        <jsp:directive.include file="viewX2.jsp" />
      </div>
    </td>
  </tr>
</table>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
