<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "DOC17"
	title	= "使用タグ検索"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>
<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />
<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID"
/>

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	<!-- 先頭のカラム名が、"WRITABLE" の場合、'true' or '1' で、書き込み許可が与えら,'2' でチェック済みになります。-->
	<jsp:text>
		select TAGNAME,COUNT(*) as CNT
		from GF77
	</jsp:text>
	<og:where>
		<og:and value = "SYSTEM_ID =  '{@MEM.SYSTEM_ID}'"     />
		<og:and value = "FGOMIT    = '{@MEM.FGOMIT}'"         />
		<og:and value = "FGJ       in  ('0','1')"         />
		<og:and value = "ADDRESS   like '{@MEM.ADDRESS}%'"    />
		<og:and value = "FILENAME  like '{@MEM.FILENAME}%'"   />
		<og:and value = "TAGNAME   like '{@MEM.TAGNAME}%'"    />
		<og:and value = "MODIFIED {@MEM.CONDITION} '{@MEM.MODIFIED}'" />
		<og:and value = "VALUELIST like '%{@MEM.VALUELIST}%'" />
	</og:where>
	<jsp:text>
		group by TAGNAME
		order by TAGNAME
	</jsp:text>
</og:query>

<!-- ViewLinkTag は、指定のカラムにリンクを張ります。keysと、valsに、URLエンコードする値を設定します。 -->
<!-- 子要素の LinkTag は、単独でも使用できます。[カラム名] で、検索結果の各行毎の値を使用できます。 -->
<og:viewLink command="{@command}">
	<og:link column="TAGNAME" gamenId="DOC02" href="index.jsp" target="CONTENTS"
		keys="command,FULLTAG,VIEW,VERSION"
		vals="NEW,[TAGNAME],,4.0.0" />
</og:viewLink>

<og:link href="result.jsp" keys="command,SYSTEM_ID" vals="NEW,{@MEM.SYSTEM_ID}" >{@LBL.UNGRPTAG}</og:link>
<br />

<!-- DB検索結果を表示させます。 -->
<!-- checked="true" で、チェック済みの状態で表示できます。 -->
<!-- selectedType="checkbox(デフォルト)/radio/hidden" から、選べます。-->

<og:view
	viewFormType = "HTMLTable"
	command    = "{@command}"
	checked    = "{@checked}"
	startNo    = "{@startNo}"
	pageSize   = "{@pageSize}"
/>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
