/**************************************************************************/
/* GF70 ( JSPチェック結果テーブル )                                       */
/*                                                                        */
/* Created : 2011/12/17 09:07:44                                          */
/**************************************************************************/
CREATE TABLE GF70 (
   SYSTEM_ID VARCHAR2(10)                 NOT NULL      /* 10  システムID   */
 , PRE_FIX   VARCHAR2(10)                 NOT NULL      /* 20  名前空間     */
 , ADDRESS   VARCHAR2(256)                              /* 30  アドレス     */
 , FILENAME  VARCHAR2(60)                               /* 40  ファイル名   */
 , FILEPATH  VARCHAR2(256)                              /* 50  ファイルパス */
 , MODIFIED  VARCHAR2(14)                               /* 60  最終更新日   */
 , TAGNAME   VARCHAR2(30)                               /* 70  タグ名称     */
 , MSGCD     VARCHAR2(20)                               /* 80  メッセージID */
 , MSGTXT    VARCHAR2(500)                              /* 90  内容         */
 , TEXT_DATA CLOB                                       /* 100 テキスト     */
 , FGOMIT    VARCHAR2(1)      DEFAULT '0' NOT NULL      /* 110 除外フラグ   */
 , UNIQ      NUMBER(9)        DEFAULT 0   NOT NULL      /* 120 ユニークキー */
 , FGJ       VARCHAR2(1)      DEFAULT '1' NOT NULL      /* 130 状態フラグ   */
 , DYSET     VARCHAR2(14)                               /* 140 登録日時     */
 , PGSET     VARCHAR2(10)                               /* 150 作成PG       */
 , PGPSET    VARCHAR2(10)                               /* 160 作成親PG     */
 , USRSET    VARCHAR2(10)                               /* 170 作成社員     */
 , DYUPD     VARCHAR2(14)                               /* 180 更新日時     */
 , PGUPD     VARCHAR2(10)                               /* 190 更新PG       */
 , PGPUPD    VARCHAR2(10)                               /* 200 更新親PG     */
 , USRUPD    VARCHAR2(10)                               /* 210 更新者       */
)
TABLESPACE GETBL01
STORAGE( INITIAL 2048K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE GF70S00 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GF70T00 
BEFORE INSERT ON GF70
FOR EACH ROW 
BEGIN 
SELECT GF70S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

