/**************************************************************************/
/* GF67 ( タスクオブジェクト定義 )                                        */
/*                                                                        */
/* Created : 2011/12/17 09:07:44                                          */
/**************************************************************************/
CREATE TABLE GF67 (
   PRJCODE VARCHAR2(30)                              /* 10  PRJコード    */
 , TASK_ID NUMBER(5)                                 /* 20  タスクID     */
 , ID      VARCHAR2(30)                NOT NULL      /* 30  ID           */
 , IDTYPE  VARCHAR2(20)                NOT NULL      /* 40  IDタイプ     */
 , UNIQ    NUMBER(9)       DEFAULT 0   NOT NULL      /* 800 ユニークキー */
 , FGJ     VARCHAR2(1)     DEFAULT '1' NOT NULL      /* 810 状態フラグ   */
 , DYSET   VARCHAR2(14)                              /* 820 登録日時     */
 , PGSET   VARCHAR2(10)                              /* 830 作成PG       */
 , PGPSET  VARCHAR2(10)                              /* 840 作成親PG     */
 , USRSET  VARCHAR2(10)                              /* 850 作成社員     */
 , DYUPD   VARCHAR2(14)                              /* 860 更新日時     */
 , PGUPD   VARCHAR2(10)                              /* 870 更新PG       */
 , PGPUPD  VARCHAR2(10)                              /* 880 更新親PG     */
 , USRUPD  VARCHAR2(10)                              /* 890 更新者       */
)
TABLESPACE GETBL01
STORAGE( INITIAL 64K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE GF67S00 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GF67T00 
BEFORE INSERT ON GF67
FOR EACH ROW 
BEGIN 
SELECT GF67S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

