<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<jsp:directive.page import="java.util.Map" />
<jsp:directive.page import="org.opengion.hayabusa.report2.ExecThreadManager" />
<jsp:directive.page import="org.opengion.hayabusa.report2.ProcessFactory" />

<og:head headType="result" />

<jsp:directive.include file="/jsp/custom/result_info.jsp" />

<og:schedule
	command		= "{@CMD}"
	scope		= "request"
	timerTask	= "org.opengion.plugin.daemon.Daemon_Report2"
	name		= "REPORT2_DAEMON"
	comment		= "Start-up By {@USER.INFO}"
	singleton	= "true"
	delay		= "0"
	period		= "5000"
	fixedDelay	= "true"
	keys		= "DEBUG"
	vals		= "{@debug}"
/>

<br />
<og:text>[DAEMON INFO]</og:text>
<og:view
	viewFormType = "HTMLTable" 
	command		= "NEW" 
	scope		= "request"
	writable	= "false"
	checked		= "{@checked}"
	startNo		= "{@startNo}" 
	pageSize	= "{@pageSize}"
	useScrollBar= "false"
	noMessage	= "true"  />

<og:equals val1="{@CMD}" val2="REMOVE">
	<jsp:scriptlet>
		ExecThreadManager.finishAllThreads();
	</jsp:scriptlet>
</og:equals>

<og:equals val1="{@CMD}" val2="VIEW">
	<br />
	<og:text>[THREAD INFO]</og:text>
	<table border="2" frame="box" rules="all" style="white-space: normal" >
	<tr><th>ID</th><th>INFO</th></tr>
	<jsp:scriptlet>
		<![CDATA[
			for( Map.Entry<String, String> entry : ExecThreadManager.getThreadInfo().entrySet() ) {
				out.println( "<tr>" );
				out.println( "<td>" + entry.getKey() + "</td><td>" + entry.getValue() + "</td>" );
				out.println( "</tr>" );
			}
		]]>
	</jsp:scriptlet>
	</table>

	<br />
	<og:text>[PROCESS INFO]</og:text>
	<br />
	<jsp:scriptlet>
		out.println( ProcessFactory.information() );
	</jsp:scriptlet>
</og:equals>

<!-- キャンセル時は、GE12から削除します。 -->
<og:equals val1="{@CMD}" val2="CANCEL" >
	<og:query command="NEW" debug="{@debug}" maxRowCount="{@maxRowCount}">
	  <jsp:text>
		DELETE FROM GE12
			WHERE SYSTEM_ID = '{@SYS.SYSTEM_ID}'
			AND   PARAM_ID = 'CONTEXT_INITIAL_CALL_URL_REPORT2_DAEMON'
			AND   FGJ = '1'
			AND   CONTXT_PATH = '{@SYS.HOST_URL}'
	  </jsp:text>
	</og:query>
	<og:query command="NEW" debug="{@debug}" maxRowCount="{@maxRowCount}">
	  <jsp:text>
		UPDATE	GE12
			SET		PARAM = replace( PARAM, 'RUN_', 'STP_')
			WHERE	SYSTEM_ID	= '{@SYS.SYSTEM_ID}'
			AND		CONTXT_PATH = '{@SYS.HOST_URL}'
			AND		PARAM_ID 	like ('REPORT2_HANDLE_DAEMON_%')
			AND		FGJ			= '1'
	  </jsp:text>
	</og:query>
	<jsp:scriptlet>
		ExecThreadManager.finishAllThreads();
	</jsp:scriptlet>
</og:equals>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
