<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system   = "GE:エンジンサンプル"
	pgid     = "REP01"
	title    = "要求テーブル"
	date     = "2007/12/12"
	author   = "K.HASEGAWA"
	text     = "ZZZZ"
	version  = "001"
/>

<!-- 変更はここからです。 -->
<og:equals val1="{@SYS.VER4_COMPATIBLE_MODE}" val2="true">
	<og:value command="SET" key="C_OUT_FILE" value="OUTFILE" />
	<og:value command="SET" key="C_OUT_DIR" value="OUTDIR" />
</og:equals>
<og:equals val1="{@SYS.VER4_COMPATIBLE_MODE}" val2="true" notEquals="true">
	<og:value command="SET" key="C_OUT_FILE" value="OUT_FILE" />
	<og:value command="SET" key="C_OUT_DIR" value="OUT_DIR" />
</og:equals>


<!-- データが選ばれていなければエラー -->
<og:columnCheck minRowCount="1" command="{@command}" >
	<jsp:directive.include file="/jsp/common/history_back.jsp" />
</og:columnCheck>

<!-- forward.jsp から command = "MODIFY" がセットされて遷移してくるので、変更画面となります。-->
<!-- カラムに対して値をセットしない場合、ColumnSetTagは不要です。 -->
<og:entry command = "{@command}" >
	<!-- action には、DEFAULT,CLEAR,ADD,LOWER,UPPER,COPY,SET,NULLSET,TBLSET が指定できます。 -->
	<og:columnSet command="{@command}" columnId="FGKAN" action="TBLSET" value="{@FGKAN}" />
</og:entry>

<!-- メッセージ表示を行います。必ずリソースファイルに表示するメッセージを登録し、 -->
<!-- lbl属性を使用して表示させて下さい。 -->
<og:message lbl="MSG0046" comment="変更処理を行います。" /><br />

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">

<!-- 登録、取消、リセットボタンを作成します。 -->
<og:writeCheck>
	<og:submit  value="entry"   lbl="ENTRY" accesskey="E" />
	<og:submit  value="reset"   lbl="RESET" accesskey="R" />
	<og:input type="reset"  name="command"  lbl="MSG0011"  td="false" />

</og:writeCheck>

<!-- 入力画面を表示します。 -->
<!-- columnWritable、または noWritable属性でカラムへの入力可／不可を指定します。 -->
<og:view
	viewFormType   = "HTMLTable"
	command        = "{@command}"
	columnWritable = "JOKEN,FGKAN,OUT_DIR,OUT_FILE,COMMENTS,PDF_PASSWD"
	checked        = "{@checked}"
	startNo        = "{@startNo}"
	pageSize       = "{@pageSize}"
/>

<og:hidden name="SQL" >
  <jsp:text>
	update GE50
	set JOKEN			=	[JOKEN]		,
		FGKAN			=	[FGKAN]		,
		{@C_OUT_DIR}	=	[OUT_DIR]	,
		{@C_OUT_FILE}	=	[OUT_FILE]	,
		COMMENTS		=	[COMMENTS]	,
		PDF_PASSWD		=	[PDF_PASSWD],
		FGJ				=	[FGJ]		,
		DYUPD			=	'{@USER.YMDH}' ,
		USRUPD			=	'{@USER.ID}' ,
		PGUPD			=	'{@GUI.KEY}'
	where 	SYSTEM_ID	=	[SYSTEM_ID]
		and YKNO		=	[YKNO]
  </jsp:text>
</og:hidden>

</form>

<!-- 変更はここまでです。 -->

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
