/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.daemon;

import java.util.Date;

import org.opengion.fukurou.util.HybsTimerTask;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.report2.ExecThreadManager;
import org.opengion.hayabusa.report2.QueueManager_DB;

/**
 * 【レポート出力】帳票要求テーブルを監視して、帳票処理プログラムを呼び出します。
 * このクラスは、HybsTimerTask を継承した タイマータスククラスです。
 * startDaemon() がタイマータスクによって、呼び出されます。
 *
 * @og.rev 4.3.4.4 (2009/01/01) プラグイン化
 * @og.group デーモン
 *
 * @version  4.0
 * @author   Hiroki.Nakamura
 * @since    JDK1.6
 */
public class Daemon_Report2 extends HybsTimerTask {

	private int loopCnt = 0;

	private static final int LOOP_COUNTER = 24; // カウンタを24回に設定
//	private static boolean DEBUG = false;
	private static boolean debug = false;		// 4.3.1.1 (2008/08/23) 変数は小文字へ

	/**
	 * このタイマータスクによって初期化されるアクションです。
	 * パラメータを使用した初期化を行います。
	 * 
	 */
	public void initDaemon() {
//		DEBUG = StringUtil.nval( getValue( "DEBUG" ),DEBUG ) ;
//		ExecThreadManager.setDebug( DEBUG ); // 4.3.0.0 (2008/04/15) デバッグ処理の追加
		debug = StringUtil.nval( getValue( "DEBUG" ),debug ) ;
		ExecThreadManager.setDebug( debug ); // 4.3.0.0 (2008/04/15) デバッグ処理の追加
	}

	/**
	 * タイマータスクのデーモン処理の開始ポイントです。
	 *
	 */
	protected void startDaemon() {
		if( loopCnt % LOOP_COUNTER == 0 ) {
			loopCnt = 1;
//			System.out.println();
			System.out.println( toString() + " " + new Date()  + " " );
		}
		else {
//			System.out.print( "." );
			loopCnt++ ;
		}

		QueueManager_DB.getInstance().create();
	}

	/**
	 * このタイマータスクのcancel() メソッドをオーバーライドします。<br />
	 * HybsTimerTaskManager#cancelTask( int ) を実行します。
	 *
	 * @og.rev 4.3.1.1 (2008/08/23) super.cancel() のみ実行なら、オーバーライドの必要はない
	 *
	 * @see java.util.TimerTask#cancel()
	 */
//	public boolean cancel() {
//		return super.cancel();
//	}
}
