<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GFX015"
	title	= "2段階検索"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>
<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID,ROLES"
	nullCheck = "SYSTEM_ID"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<!-- scope="request" により、一時的にDB検索を行い、結果はキャッシュしません。-->
<og:query command="{@command}" debug="{@debug}" scope="request" maxRowCount="{@maxRowCount}">
	<jsp:text>
		select SYSTEM_ID,USERID,LANG,NAME_JA,ROLES,FGJ
		from GEA10
		where FGJ         in  ('0','1')
		and   SYSTEM_ID   = '{@SYSTEM_ID}'
		and   ROLES || 'x' = '{@ROLES}x'
		order by SYSTEM_ID,USERID
	</jsp:text>
</og:query>

<!-- ViewLinkTag は、指定のカラムにリンクを張ります。keysと、valsに、URLエンコードする値を設定します。 -->
<!-- 子要素の LinkTag は、単独でも使用できます。[カラム名] で、検索結果の各行毎の値を使用できます。 -->
<og:viewLink command="{@command}">
	<!-- LinkTag で、画面遷移を行う場合は、gamenId属性を使用してください。-->
	<og:link column="USERID" gamenId="TYPE5A" href="result.jsp" target="RESULT"
		keys="command,SYSTEM_ID,ROLES,USERID,LINK_REQ"
		vals="NEW,[SYSTEM_ID],[ROLES],[USERID],true" />
</og:viewLink>

<!-- ViewMarkerTag は、指定のカラムをマーキングします。 -->
<og:viewMarker command="{@command}">
	<!-- 子要素の ColumnMarkerTag のBODY部と表示（レンデラー）を置き換えます。 -->
	<!-- onMark="true" または ="1" のときのみ、置き換えを行います。onMark=[カラム名] が使用できます。 -->
	<!-- markList を使用すれば、任意の文字列でのマーキングが可能です。-->
	<og:columnMarker column="NAME_JA" onMark="[USERID]" markList="{@USERID}" >
		<span style="font-weight:bold; background-color:#ccffff">[NAME_JA]</span>
	</og:columnMarker>
</og:viewMarker>

<!-- DB検索結果を表示させます。 -->
<!-- scope="request" により、一時的にDB検索した結果から、画面表示を行います。-->
<og:view
	scope      = "request"
	viewFormType = "HTMLTable"
	command    = "{@command}"
	noDisplay  = "FGJ"
	checked    = "{@checked}"
	startNo    = "{@startNo}"
	writable   = "false"
	pageSize   = "{@pageSize}"  />

<!-- {@LINK_REQ}がtrueの場合のみ、以下の処理を行います。-->
<og:equals val1="{@LINK_REQ}" val2="true" >
  <og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	<jsp:text>
		select GUIKEY,ADDRESS,SEQNO,NAME_JA,
				ROLES,RWMODE,TARGET,SYSTEM_ID,FGJ,UNIQ
		from GEA11
		where SYSTEM_ID = '{@SYSTEM_ID}'
		and   ( instr( ROLES,'{@ROLES}' ) &gt; 0
				or    LENGTH( '{@ROLES}' ) = 0
				or    '{@ROLES}' in ('root','system','admin')
		)
		order by SEQNO
	</jsp:text>
  </og:query>

<!-- DB検索結果を表示させます。 -->
<!-- checked="true" で、チェック済みの状態で表示できます。 -->
<og:view
	viewFormType = "HTMLTable"
	command    = "{@command}"
	noDisplay  = "FGJ,UNIQ"
	checked    = "{@checked}"
	startNo    = "{@startNo}"
	pageSize   = "{@pageSize}"  />

</og:equals>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
