/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.hayabusa.remote;

import java.util.Map;

/**
 * リモートサーブレットからクラスを利用するためのインタフェイスです。
 * マップでキーと値を渡します。
 * CSV形式等で値を渡した場合はクラスで分解処理を行って下さい。
 *
 * @og.rev 4.1.0.0 (2007/12/20) 新規作成
 * @version  4.1
 * @author   Masakazu Takahashi
 * @since    JDK6.0,
 */
public interface RemoteControllable {

	/**
	 * RemoteControlServletで呼び出したクラスが実行するメソッドです。
	 * 結果はXML形式の文字列で返して下さい。
	 * キーと値をMAPに格納してクラスに渡します。
	 * CSV形式等の分解は受け取ったクラス側で行います。
	 *
	 * @param valMap MAP<String,String> クラスに渡すキーと値
	 * @return String XML形式の実行結果
	 */
	String remoteControl( Map<String,String> valMap );
}
