/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package gf;

import org.opengion.fukurou.business.BizLogic_ENTRY;

/**
 * GF41に登録をためのサブルーチンです。
 * システムID + 言語 + カラム名に対して、データがなければ追加、あれば更新を行います。
 *
 * @og.rev 5.1.1.0 (2009/12/01) 新規作成
 * @og.group 業務ロジック
 * 
 * @version 5.0
 * @author Hiroki Nakamura
 * @since JDK1.6,
 */

public class GF0001 extends BizLogic_ENTRY {

	/**
	 * チェックロジックを定義します。
	 * 
	 * @return 処理が正常終了したか
	 */
	protected boolean check() {
		return must( "SYSTEM_ID,LANG,CLM" );
	}

	/**
	 * メイン処理を定義します。
	 * 
	 * @return 処理が正常終了したか
	 */
	protected boolean logic() {
		String cnt = "select count(*) CNT from GF41 "
			+ "where system_id='{@SYSTEM_ID}' and lang='{@LANG}' and clm='{@CLM}'";
		sql( cnt );

		if( vari( "CNT" ) == 0 ) {
			String ins = "insert into GF41("
				+ "system_id, lang, clm, name_ja, label_name, kbsaku, fgj "
				+ ", dyset, usrset, pgset, pgpset, dyupd, usrupd, pgupd, pgpupd"
				+ ") values ("
				+ "'{@SYSTEM_ID}', '{@LANG}', '{@CLM}', '{@NAME_JA}', '{@LABEL_NAME}', '{@KBSAKU}', '1' "
				+ ", '{@CON.YMDH}', '{@CON.USERID}', '{@CON.PGID}', '{@CON.PGPID}', '{@CON.YMDH}', '{@CON.USERID}', '{@CON.PGID}', '{@CON.PGPID}'"
				+ ")";
			sql( ins );
		}
		else {
			String upd = "update GF41 set "
				+ "name_ja = '{@NAME_JA}' "
				+ ",label_name = '{@LABEL_NAME}' "
				+ ",kbsaku = '{@KBSAKU}' "
				+ ",system_id = '{@SYSTEM_ID}' "
				+ ",lang = '{@LANG}' "
				+ ",dyupd = '{@CON.YMDH}' "
				+ ",usrupd = '{@CON.USERID}' "
				+ ",pgupd = '{@CON.PGID}' "
				+ ",pgpupd = '{@CON.PGPID}' "
				+ "where system_id = '{@SYSTEM_ID}' "
				+ "and clm = '{@CLM}' "
				+ "and lang = '{@LANG}' ";
			sql( upd );
    	}

		return true;
	}
}
