<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF6070"
	title	= "クロス集計"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>
<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
/>

<!-- 空の DBTableModel を作成します。 １件目のデータでも可 -->
<!-- このデータは、tableMergeするときの、マスターテーブルになります。 -->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}" notfoundMsg="">
	<jsp:text>
		SELECT {@CUBE_X},{@CUBE_Y},SAL AS KEI
		FROM EMP
		WHERE 1 = 2
	</jsp:text>
</og:query>

<!-- ループ処理する条件を作成します。 データベースから求める場合は、action="APPEND" で作成  -->
<og:value command="SET" key="TBL_LIST" value="1,2,3,4,5" />

<!-- ループ処理します。何をしているかというと、データを大量に捏造しています。-->
<c:forTokens var="no" delims="," items="${TBL_LIST}" >
	<!-- tableMergeするときの、スレーブテーブル -->
	<og:query command="{@command}" scope="request" debug="{@debug}" maxRowCount="{@maxRowCount}">
		<jsp:text>
			SELECT {@CUBE_X},{@CUBE_Y}*${no} as {@CUBE_Y},SAL AS KEI
			FROM EMP
			union
			SELECT substr({@CUBE_X},1,${no}) as {@CUBE_X},{@CUBE_Y}*${no} as {@CUBE_Y},SAL AS KEI
			FROM EMP
			ORDER BY {@CUBE_X},{@CUBE_Y}
		</jsp:text>
	</og:query>

	<!-- アスターに、スレーブテーブルを、UNION_ALL します。-->
	<og:tableMerge
		action		= "UNION_ALL"
		masterScope	= "session"
		slaveScope	= "request"
		display		= "false"
	/>
</c:forTokens>

<!-- ViewLinkTag は、指定のカラムにリンクを張ります。keysと、valsに、URLエンコードする値を設定します。 -->
<!-- 子要素の LinkTag は、単独でも使用できます。[カラム名] で、検索結果の各行毎の値を使用できます。 -->
<og:viewLink command="{@command}">
	<og:link column="{@CUBE_X}" gamenId="GF9500" href="index.jsp" target="CONTENTS"
		keys="command,{@CUBE_X},KEI"
		vals="NEW,[{@CUBE_X}],[KEI]" />
	<og:link column="KEI" gamenId="GF9500" href="index.jsp" target="CONTENTS"
		keys="command,KEI"
		vals="NEW,[KEI]" />
</og:viewLink>

<style type="text/css">
	.x7698 { background-color:#ccff00; }
	.MANAGER { background-color:#ccff00; }
</style>

<og:view
	viewFormType = "HTMLCrossTable"
	command    = "{@command}"
	checked    = "{@checked}"
	startNo    = "{@startNo}"
	pageSize   = "{@pageSize}"
	useParam   = "true"
	noDisplay  = "KEI"
  >
	<og:crossParam
		cubeXColumn		= "{@CUBE_X}"
		cubeYColumn		= "{@CUBE_Y}"
		gokeiLabel		= " "
		cubeSortType	= "{@cubeSortType}"
		gokeiSortDir	= "{@gokeiSortDir}"
		useHeaderColumn = "{@useHeaderColumn}"
		saveTableId		= "{@saveTableId}"
		useClassAdd		= "{@useClassAdd}"
	/>
</og:view>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
