<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system   = "GE:エンジンサンプル"
	pgid     = "REP07"
	title    = "エラーテーブル"
	date     = "2007/12/12"
	author   = "K.HASEGAWA"
	text     = "ZZZZ"
	version  = "001"
/>

<!-- 変更はここから -->
<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
	columns   = "FGJ,SYSTEM_ID,YKNO,EDNO,KBTEXT"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	<jsp:text>
		select	YKNO, UNIQSEQ, ERRMSG, FGJ, SYSTEM_ID,
				DYSET, DYUPD, USRSET, USRUPD, PGUPD
		from    GE56
	</jsp:text>
	<!-- 検索条件でWhereTagを使用すれば{@xxxx}がNULLの場合、その条件は無視されます。 -->
	<og:where>
		<og:and value = "FGJ = '1'" />
		<og:and value = "SYSTEM_ID = '{@SYSTEM_ID}'" />
		<og:and value = "YKNO = '{@YKNO}'" />
	</og:where>
	<!-- ORDER BY句でAppearTagを使用すれば{@ORDER_BY}がNULLの場合、ORDER BY句は無視されます。 -->
	<!-- また、{@ORDER_BY}がNULLの場合に、defaultVal属性を指定すれば、その値でORDER BY表示されます。 -->
	<og:appear startKey=" order by" value="{@SORT}" defaultVal="SYSTEM_ID,YKNO DESC,UNIQSEQ DESC" />
</og:query>

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">

<!-- 追加、複写、変更、削除ボタンを作成します。 -->
<og:writeCheck>
	<og:submit  value="delete"   lbl="DELETE"  accesskey="D" />
</og:writeCheck>

<og:view
	viewFormType = "HTMLCustomTable"
	command 	 = "{@command}"
	checked      = "{@checked}"
	startNo      = "{@startNo}" 
	pageSize     = "{@pageSize}"
	useScrollBar = "false"
	rowspan      = "1"  >
	<og:thead rowspan = "1">
		<tr><td>[SYSTEM_ID]<br />[YKNO]<br />[UNIQSEQ]<br />
				[DYSET]<br />[DYUPD]<br />[USRSET]<br />[USRUPD]<br />[PGUPD]
			</td>
			<td><pre>[ERRMSG]</pre></td>
		</tr>
	</og:thead>
	<og:tbody rowspan = "1">
		<tr><td style="vertical-align:top;">SYSTEM_ID=[SYSTEM_ID]<br />YKNO=[YKNO]<br />SEQ=[UNIQSEQ]<br />
				[DYSET]<br />[DYUPD]<br />[USRSET]<br />[USRUPD]<br />[PGUPD]
			</td>
			<td><pre>[ERRMSG]</pre></td>
		</tr>
	</og:tbody>
</og:view>

</form>

<!-- ここまで。 -->
	<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
