/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Locale;
import org.opengion.fukurou.util.Attributes;
import org.opengion.fukurou.util.ErrorMessage;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.fukurou.util.XHTMLTag;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.taglib.CommonTagSupport;
import org.opengion.hayabusa.taglib.TaglibUtil;

public class ErrorMessageTag
extends CommonTagSupport {
    private static final String VERSION = "4.0.0 (2005/08/31)";
    private static final long serialVersionUID = 4000L;
    public static final String CMD_NEW = "NEW";
    public static final String CMD_RENEW = "RENEW";
    public static final String CMD_RESET = "RESET";
    public static final String CMD_REVIEW = "REVIEW";
    private static final String errMsgId = "h_errMsg";
    private final String errMsgFile = HybsSystem.sys("ERR_MSG_FILENAME");
    private final int maxRowCount = HybsSystem.sysInt("DB_MAX_ROW_COUNT");
    private transient ErrorMessage errMessage = null;
    private String command = null;
    private boolean msgClear = false;
    private String viewType = "TITLE";
    private String displayMsg = "MSG0059";
    private String warningMsg = "ERR0020";

    @Override
    public int doStartTag() {
        if (this.msgClear || CMD_NEW.equals(this.command) || CMD_RESET.equals(this.command)) {
            this.removeSessionAttribute(errMsgId);
            this.msgClear = true;
        } else {
            this.errMessage = (ErrorMessage)this.getSessionAttribute(errMsgId);
            if (this.errMessage == null) {
                this.msgClear = true;
            }
        }
        return 0;
    }

    @Override
    public int doEndTag() {
        this.debugPrint();
        String string = null;
        if (this.errMessage == null) {
            if ((CMD_REVIEW.equals(this.command) || CMD_RENEW.equals(this.command)) && (string = this.getResource().getLabel(this.displayMsg)) != null && string.length() > 0) {
                string = string + HybsSystem.BR;
            }
        } else if ("TITLE".equalsIgnoreCase(this.viewType)) {
            string = this.makeTitle();
        } else if ("BODY".equalsIgnoreCase(this.viewType)) {
            string = TaglibUtil.makeHTMLErrorTable(this.errMessage, this.getResource());
        } else {
            String string2 = "viewType\u5c5e\u6027\u306b TITLE/BODY \u4ee5\u5916\u306e\u9805\u76ee\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059\u3002[" + this.viewType + "]";
            throw new HybsSystemException(string2);
        }
        this.jspPrint("<span class=\"errmsg\">");
        if (string != null && string.length() > 0) {
            this.jspPrint(string);
        }
        this.jspPrint("</span>");
        return 6;
    }

    @Override
    protected void release2() {
        super.release2();
        this.command = null;
        this.errMessage = null;
        this.msgClear = false;
        this.viewType = "TITLE";
        this.displayMsg = "MSG0059";
        this.warningMsg = "ERR0020";
    }

    private String makeTitle() {
        String string = this.getContextPath() + "/" + this.errMsgFile;
        Attributes attributes = new Attributes();
        attributes.set("href", string);
        attributes.set("target", "_blank");
        String string2 = this.warningMsg != null ? "<span class=\"msg_warning\">" + this.getResource().getLabel(this.warningMsg) + "</span>" + HybsSystem.BR : "<span class=\"msg_error\">" + this.errMessage.getTitle() + "</span>" + HybsSystem.BR;
        attributes.set("body", string2);
        String string3 = "pageSize";
        String string4 = String.valueOf(this.maxRowCount);
        String string5 = XHTMLTag.urlEncode((String)string3, (String)string4);
        return XHTMLTag.link((Attributes)attributes, (String)string5);
    }

    public void setCommand(String string) {
        String string2 = this.getRequestParameter(string);
        if (string2 != null && string2.length() > 0) {
            this.command = string2.toUpperCase(Locale.JAPAN);
        }
    }

    public void setClear(String string) {
        this.msgClear = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.msgClear);
    }

    public void setViewType(String string) {
        this.viewType = StringUtil.nval((String)this.getRequestParameter(string), (String)this.viewType);
    }

    public void setDisplayMsg(String string) {
        this.displayMsg = StringUtil.nval((String)this.getRequestParameter(string), (String)this.displayMsg);
    }

    public void setWarningMsg(String string) {
        String string2 = this.getRequestParameter(string);
        if (string2 != null) {
            this.warningMsg = string2;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("errMsgId", (Object)errMsgId).println("errMsgFile", (Object)this.errMsgFile).println("maxRowCount", (Object)this.maxRowCount).println("command", (Object)this.command).println("msgClear", (Object)this.msgClear).println("viewType", (Object)this.viewType).println("displayMsg", (Object)this.displayMsg).println("warningMsg", (Object)this.warningMsg).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }
}

