/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.fukurou.util;

/**
 * ConnectIF.java は、サーバーアクセス関連のクラスを共通的に使用するためのインターフェースです。
 *
 * connect()、action( String command, String localFile, String remoteFile )、disconnect() の
 * 一連処理のメソッドと、setHostUserPass( String host , String user , String pass ) 、getErrMsg() の
 * 簡易的な共通メソッドを用意しています。
 *
 * @og.rev 5.1.6.0 (2010/05/01) 新規追加
 *
 * @version  5.0
 * @author	 Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
public interface ConnectIF {

	/**
	 * サーバーへの接続、ログインを行います。
	 *
	 * このメソッドは、初期化メソッドです。
	 * 接続先を変更する場合は、もう一度このメソッドをコールする必要があります。
	 * (そのような場合は、通常、オブジェクトを構築しなおす方がよいと思います。)
	 */
	public void connect() ;

	/**
	 * command , localFile , remoteFile を元に、処理を行います。
	 *
	 * このメソッドは、connect()メソッド実行後に、呼び出す必要があります。
	 *
	 * @param	command String GET/PUT/DEL など
	 * @param	localFile  String ローカルのファイル名
	 * @param	remoteFile String 接続先のファイル名
	 */
	public void action( final String command, final String localFile, final String remoteFile );

	/**
	 * サーバーとの接続をクローズします。
	 *
	 * ログインされている場合は、ログアウトも行います。
	 * コネクトされている場合は、ディスコネクトします。
	 */
	public void disconnect();

	/**
	 * サーバーの、ホスト、ユーザー、パスワードを設定します。
	 *
	 * @param	host String サーバー
	 * @param	user String ユーザー
	 * @param	pass String パスワード
	 */
	public void setHostUserPass( final String host , final String user , final String pass );

	/**
	 * 接続に利用するポート番号を設定します。
	 *
	 * @param	port String 接続に利用するポート番号
	 */
	public void setPort( final String port ) ;

	/**
	 * それぞれの受け側ファイルにディレクトリを作成するかどうか。(初期値：true:作成する)
	 *
	 * -mkdirs=[true/false] は、受け側のファイル(GET時:LOCAL、PUT時:サーバー)に取り込むファイルのディレクトリが
	 * 存在しない場合に、作成するかどうかを指定します。(初期値：true)
	 * 通常、サーバーに、フォルダ階層を作成してPUTする場合、動的にフォルダ階層を作成したいケースで便利です。
	 * 逆に、フォルダは確定しており、指定フォルダ以外に PUT するのはバグっていると事が分かっている場合には
	 * false に設定して、存在しないフォルダにPUT しようとすると、エラーになるようにします。
	 *
	 * @param	isMkdirs boolean 受け側ファイルにディレクトリを作成するかどうか。true:作成する
	 */
	public void setMkdirs( final boolean isMkdirs ) ;

	/**
	 * Dataタイムアウトを秒で指定します。(初期値：600 [秒]）
	 *
	 * オリジナルの FTPClient#setDataTimeout( int ) は、ミリ秒でセット
	 * しますが、ここのメソッドでは、秒でセットします。
	 *
	 * @param	timeout int タイムアウト[秒]
	 */
	public void setTimeout( final int timeout ) ;

	/**
	 * 実行状況の表示可否 を設定します。（初期値 false:表示しない)
	 *
	 * @param	isDisplay boolean 実行状況の表示可否
	 */
	public void setDisplay( final boolean isDisplay ) ;

	/**
	 * デバッグ情報の表示可否 を設定します。（初期値 false:表示しない)
	 *
	 * @param	isDebug boolean デバッグ情報の表示可否
	 */
	public void setDebug( final boolean isDebug ) ;

	/**
	 * 処理中に発生したエラーメッセージを取り出します。
	 *
	 * @return	String エラーメッセージ
	 */
	public String getErrMsg();
}
