<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "ORA09"
	title	= "SQL洗い出し"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<og:query command="{@command}" debug="{@debug}" dbid="{@DBID}" maxRowCount="{@maxRowCount}">
	<jsp:text>
		select
			SORTS           ,
			FETCHES         ,
			EXECUTIONS      ,
			PARSE_CALLS     ,
			DISK_READS      ,
			BUFFER_GETS     ,
			ROWS_PROCESSED  ,
			LOADS           ,
			CPU_TIME        ,
			ELAPSED_TIME    ,
			SQL_TEXT        ,
			HASH_VALUE
		from
		   V$SQL
	</jsp:text>
		<og:appear startKey = "ORDER BY" value = "{@SQL_ORDER_BY}"
				defaultVal = "CPU_TIME DESC" />
</og:query>

<!-- ViewLinkTag は、指定のカラムにリンクを張ります。keysと、valsに、URLエンコードする値を設定します。 -->
<!-- 子要素の LinkTag は、単独でも使用できます。[カラム名] で、検索結果の各行毎の値を使用できます。 -->

<og:viewLink command="{@command}">
	<og:link column="SQL_TEXT" gamenId="ORA09" href="display.jsp" target="RESULT"
		keys="command,HASH_VALUE,DBID"
		vals="NEW,[HASH_VALUE],{@DBID}" />
</og:viewLink>

<og:view
	viewFormType = "HTMLTable"
	command    = "{@command}"
	noDisplay  = "HASH_VALUE"
	writable   = "false"
	startNo    = "{@startNo}"
	pageSize   = "{@pageSize}" />

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
