<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="init" />
<!-- command="ENTRY"時は、nullCheck のみ有効です。カラムに付いては、全カラムをチェックしています。-->
<og:columnCheck
	command   = "{@command}"
	nullCheck = "SYSTEM_ID,LANG,CLM"
/>

<!-- command="ENTRY"時は、リクエスト情報（カラム名__行番号)を、DBTableModelにセットします。-->
<!-- カラムに対して値をセットしない場合、ColumnSetTagは不要です。 -->
<og:entry command="{@command}" />

<!-- TableExistTag は、command="ENTRY" のときのみ有効です。-->
<!-- データベースに対して、exist属性の、｢true:存在する｣、｢false:存在しない｣、｢one:ひとつのみ｣ -->
<!-- にしたがってチェックします。INSERT時はfalseを、UPDATE,DELETE時はtrueをセットします。 -->
<!-- names属性の並び順と、where属性の?の並び順は、対応させてください。-->
<og:tableExist
	dbid    = "{@MEM.DBID}"
	command = "{@command}"
	names   = "SYSTEM_ID,LANG,CLM"
	from    = "GF41"
	where   = "SYSTEM_ID=? AND LANG=? AND CLM=? AND FGJ IN ('0','1')"
	exist   = "{@exist}"  />

<!-- 前画面のSQL文を実行する場合に、UpdateTag の queryType="JDBCPrepared"を指定します。-->
<!-- 通常は変更する必要はありません。 -->
<og:update
	dbid      = "{@MEM.DBID}"
	command   = "{@command}"
	queryType = "JDBCPrepared"
	names     = "{@names}"  >
<jsp:text>{@SQL}</jsp:text>
</og:update>

<!-- 前画面で指定のSQL文を削除します。(scope="session"なので削除が必要。) -->
<og:value scope="session" key="names" command="REMOVE" />
<og:value scope="session" key="SQL"   command="REMOVE" />

<og:forward page="result.jsp" keys="command" vals="RENEW" />
<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>

