<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF6130"
	title	= "左右分割スクロール"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID,LANG,CLM"
	nullCheck = "SYSTEM_ID"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<og:equals val1="{@LVL_MI}" nullCheck="true">
  <og:query command="{@command}" debug="{@debug}" dbid="{@FROM_DBID}" maxRowCount="{@maxRowCount}">
	<jsp:text>
		select '1' as WRITABLE,CLM,NAME_JA,LNAME,SNAME,DESCRIPTION,COMMENTS,KBSAKU,KBLBL,
				SYSTEM_ID,LANG,RDC_CODE,RELEASE_NOTES,DYUPD,CDKH,FGJ,UNIQ
		from GEA08
		where SYSTEM_ID in ( '{@SYSTEM_ID}','{@AST}' )
	</jsp:text>
	<og:where startKey="and">
		<og:and value = "FGJ		=	'{@FGJ}'"		 />
		<og:and value = "LANG		=	'{@LANG}'"		 />
		<og:and value = "UPPER(CLM)	like UPPER('{@CLM}%')" />
		<og:and value = "NAME_JA		like '{@NAME_JA}%'"	 />
		<og:and value = "LNAME			like '{@LNAME}%'" 	 />
		<og:and value = "SNAME			like '{@SNAME}%'" 	 />
		<og:and value = "DESCRIPTION	like '{@DESCRIPTION}%'" 	 />
		<og:and value = "KBSAKU	=	'{@KBSAKU}'"	 />
		<og:and value = "KBLBL		=	'{@KBLBL}'"	 />
		<og:and value = "( CLM = NAME_JA {@NAME_MI} NAME_JA is null )" />
		<og:and value = "RDC_CODE     = '{@RDC_CODE}'"		/>
		<og:and value = "DYUPD 	&gt;= '{@DYUPDFROM}'"	/>
		<og:and value = "DYUPD		&lt;= '{@DYUPDTO}99'"	/>
		<og:and value = "RELEASE_NOTES like '{@RELEASE_NOTES}%'" />
		<og:and value = "USRUPD       =    '{@USRUPD}'"  />
		<og:and value = "CDKH {@CDKH}" />
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "SYSTEM_ID,LANG,CLM" />
  </og:query>
</og:equals>

<og:equals val1="{@LVL_MI}" val2="{@LVL_MI}">
  <og:query command="{@command}" debug="{@debug}" dbid="{@FROM_DBID}" maxRowCount="{@maxRowCount}">
	<jsp:text>
		select A.CLM,A.NAME_JA,B.USE_LENGTH,A.LNAME,A.SNAME,A.DESCRIPTION,
				A.KBSAKU,A.SYSTEM_ID,A.LANG,A.FGJ,A.UNIQ
		from GEA08 A inner join GEA03 B
		on   A.SYSTEM_ID = B.SYSTEM_ID
		and  A.CLM       = B.CLM
	</jsp:text>
	<og:where>
		<og:and value = "A.FGJ			in	('0','1')" 		/>
		<og:and value = "B.FGJ			in	('0','1')"		/>
		<og:and value = "A.SYSTEM_ID	=	'{@SYSTEM_ID}'"	/>
		<og:and value = "A.LANG		=	'{@LANG}'"		/>
		<og:and value = "A.CLM 		like '{@CLM}%'"		/>
		<og:and value = "A.NAME_JA		like '{@NAME_JA}%'"	/>
		<og:and value = "A.LNAME		like '{@LNAME}%'"	/>
		<og:and value = "A.DESCRIPTION	like '{@DESCRIPTION}%'"  />
		<og:and value = "A.CDKH {@CDKH}" />
	</og:where>
	<jsp:text>
	and   A.SNAME is null
	and   B.NAME_JA != A.LNAME
	and   B.EDITOR not in ('MENU','DBMENU','CHBOX')
	order by A.SYSTEM_ID,A.LANG,A.CLM
	</jsp:text>
  </og:query>
</og:equals>

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">
<og:writeCheck>
	<og:input name="repeatCount" value="1" lbl="" td="false" size="2"/>
	<og:submit  value="copy"     lbl="COPY"    accesskey="C" />
	<og:submit  value="modify"   lbl="MODIFY"  accesskey="M" />
	<og:submit  value="delete"   lbl="DELETE"  accesskey="D" />

	<og:equals val1="{@ACTION}" val2="{@ACTION}" notEquals="true">
		<fieldset style="display:inline;">
			<legend><strong><og:message lbl="INSERT_GEA08" /></strong></legend>
			<og:column  name="SYSTEM_ID" useRequestValue="false" td="no" />
			<og:submit  value="insertGEA08" lbl="INSERT" command="COPY" />
		</fieldset>
		<og:submit  value="deletePH" lbl="DELETE_PH" command="DELETE" roles="DEL" />

<!--
<table>
<tr>
	<td><og:submit  value="deletePH" lbl="DELETE_PH" command="DELETE" roles="DEL" /></td>
	<td><og:submit  value="deletePH" lbl="DELETE_PH" command="DELETE" roles="DEL" /></td>
	<td><og:submit  value="deletePH" lbl="DELETE_PH" command="DELETE" roles="DEL" /></td>
	<td><og:submit  value="deletePH" lbl="DELETE_PH" command="DELETE" roles="DEL" /></td>
	<td><og:submit  value="deletePH" lbl="DELETE_PH" command="DELETE" roles="DEL" /></td>
	<td><og:submit  value="deletePH" lbl="DELETE_PH" command="DELETE" roles="DEL" /></td>
	<td><og:submit  value="deletePH" lbl="DELETE_PH" command="DELETE" roles="DEL" /></td>
	<td><og:submit  value="deletePH" lbl="DELETE_PH" command="DELETE" roles="DEL" /></td>
	<td><og:submit  value="deletePH" lbl="DELETE_PH" command="DELETE" roles="DEL" /></td>
	<td><og:submit  value="deletePH" lbl="DELETE_PH" command="DELETE" roles="DEL" /></td>
	<td><og:submit  value="deletePH" lbl="DELETE_PH" command="DELETE" roles="DEL" /></td>
	<td><og:submit  value="deletePH" lbl="DELETE_PH" command="DELETE" roles="DEL" /></td>
</tr>
</table>
-->
	</og:equals>
<!--
	<og:submit  value="updateKBLBL" command="UPDATE" lbl="{@LBL.KBLBL} Set" />
-->
	<br />
</og:writeCheck>

<og:viewLink command="{@command}">
	<og:link column="CLM" gamenId="GF9100" href="index.jsp" target="CONTENTS"
		keys="command,SYSTEM_ID,CLM,FGJ"
		vals="NEW,{@SYSTEM_ID},[CLM],1" />
</og:viewLink>

<!-- ACTION が指定された場合は、tableMerge により積集合/差分集合を取得します。-->
<og:equals val1="{@ACTION}" val2="{@ACTION}">
	<og:query dbid="{@TO_DBID}" scope="request" quotCheck="false" maxRowCount="{@maxRowCount}">
		<jsp:text>{@USER.LASTSQL}</jsp:text>
	</og:query>
	<og:tableMerge
		action        = "{@ACTION}"
		masterScope   = "session"
		masterKeys    = "SYSTEM_ID,CLM,LANG"
		diffKeys      = "NAME_JA,LNAME,SNAME,DESCRIPTION,KBSAKU"
		slaveScope    = "request"
		modifyClms    = "UNIQ"
		display       = "true"
	/>
</og:equals>

<style>
    #GantBody div tr { height:22px; }
</style>
<table id="GantBody" border="0px" cellpadding="0px" cellspacing="0px" frame="box" rules="all" style="margin:0px;padding:0px;">
  <tr style="margin:0px;padding:0px;">
    <td valign="top" style="margin:0px; padding:0px;" >
      <div id="X1" style="overflow-x:hidden; overflow-y:hidden;" >
        <jsp:directive.include file="viewX1.jsp" />
      </div>
    </td>
    <td  valign="top" style="margin:0px; padding:0px;">
      <div id="X2" style="position:absolute; overflow-x:hidden; overflow-y:hidden;" >
        <jsp:directive.include file="viewX2.jsp" />
      </div>
    </td>
  </tr>
</table>
<!-- 
<og:view
	viewFormType = "HTMLTable"
	command    = "{@command}"
	noDisplay  = "UNIQ"
	checked    = "{@checked}"
	startNo    = "{@startNo}"
	pageSize   = "{@pageSize}" />
-->

</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
