<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "DOC19"
	title	= "作成区分メンテ"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>
<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />
<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID"
	nullCheck = "SYSTEM_ID"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}"/>

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command = "{@command}" debug = "{@debug}" maxRowCount = "{@maxRowCount}" >
	<!-- 先頭のカラム名が、"WRITABLE" の場合、'true' or '1' で、書き込み許可が与えら,'2' でチェック済みになります。-->
	<jsp:text>
		SELECT SYSTEM_ID, SOURCE, COUNT(*) AS RSC
		FROM GF79
		WHERE SYSTEM_ID = '{@SYSTEM_ID}'
	</jsp:text>
	<og:where startKey = "and" >
		<og:and value = "SYSTEM_ID		in  ('{@SYSTEM_ID}','{@AST}')"	/>
		<og:and value = "FGOMIT		= '{@FGOMIT}'"					/>
		<og:and value = "FGJ			in  ('0','1')"					/>
		<og:and value = "SOURCE		like '{@SOURCE}%'"				/>
		<og:and value = "FILENAME		like '{@FILENAME}%'"			/>
		<og:and value = "TAGNAME		like '{@TAGNAME}%'"				/>
		<og:and value = "MODIFIED		{@CONDITION} '{@MODIFIED}'"		/>
		<og:and value = "NAME_JA			like '{@NAME_JA}%'"				/>
	</og:where>
	<jsp:text>
		GROUP BY SYSTEM_ID, SOURCE
		ORDER BY SYSTEM_ID, SOURCE
	</jsp:text>
</og:query>

<!-- formタグでリクエストフィールドを囲います。oneClick()関数は、２重押し防止JavaScriptです。 -->
<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">

<!-- 複写、変更、削除ボタンを作成します。value属性+.jspの画面に制御が移ります。 -->
<!-- このとき、command=(value属性の値の大文字)が設定されます。 command属性で設定しなおすことも出来ます。-->
<!-- KBSAKU変更はroles="root"を指定する事で管理者権限を持つ者のみ表示されるようにします -->
<og:writeCheck>
	<fieldset style="display:inline;">
		<legend><strong><og:message lbl = "MODIFY_KBSAKU" /></strong></legend>
		<og:submit value	= "KBSAKUentry" lbl = "KB_ENTRY" command = "ENTRY" roles="root" />
	</fieldset>
	<fieldset style="display:inline;">
		<legend><strong><og:message lbl = "MODIFY_FGLOAD" /></strong></legend>
		<og:submit value = "FGLOADentry" lbl = "FG_ENTRY" command = "ENTRY" />
	</fieldset>
</og:writeCheck>

<br />
<og:message lbl = "GFM0042" language = "{@USER.LANG}" /><br />
<og:message lbl = "GFM0043" language = "{@USER.LANG}" /><br />
<og:message lbl = "GFM0044" language = "{@USER.LANG}" /><br />

<!-- DB検索結果を表示させます。 -->
<!-- checked="true" で、チェック済みの状態で表示できます。 -->
<!-- selectedType="checkbox(デフォルト)/radio/hidden" から、選べます。-->

<og:view
	viewFormType	= "HTMLTable"
	command			= "{@command}"
	checked			= "{@checked}"
	startNo			= "{@startNo}"
	pageSize		= "{@pageSize}"
/>
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
