/**************************************************************************/
/* GF95 ( DBセット基準書 )                                                */
/*                                                                        */
/* Created : 2010/08/02 13:05:59                                          */
/**************************************************************************/
CREATE TABLE GF95 (
   SYSTEM_ID  VARCHAR2(10)                               /* 10  システムID     */
 , PGID       VARCHAR2(30)                 NOT NULL      /* 20  PG-ID          */
 , NMSYORI    VARCHAR2(100)                              /* 30  処理グループ名 */
 , SEQ        NUMBER(7)        DEFAULT 0   NOT NULL      /* 40  順             */
 , TABLE_NAME VARCHAR2(50)                 NOT NULL      /* 50  テーブル名     */
 , CLM        VARCHAR2(30)                               /* 60  項目           */
 , MOTO       VARCHAR2(30)                               /* 70  入力元         */
 , ADDACT     VARCHAR2(500)                              /* 80  追加時         */
 , MODIACT    VARCHAR2(500)                              /* 90  更新時         */
 , DELACT     VARCHAR2(500)                              /* 100 削除時         */
 , UNIQ       NUMBER(9)        DEFAULT 0   NOT NULL      /* 110 ユニークキー   */
 , FGJ        VARCHAR2(1)      DEFAULT '1' NOT NULL      /* 120 状態フラグ     */
 , DYSET      VARCHAR2(14)                               /* 130 登録日時       */
 , USRSET     VARCHAR2(10)                               /* 140 作成社員       */
 , DYUPD      VARCHAR2(14)                               /* 150 更新日時       */
 , PGUPD      VARCHAR2(10)                               /* 160 更新PG         */
 , USRUPD     VARCHAR2(10)                               /* 170 更新者         */
)
TABLESPACE GETBL01
STORAGE( INITIAL 16K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE GF95S00 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GF95T00 
BEFORE INSERT ON GF95
FOR EACH ROW 
BEGIN 
SELECT GF95S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

