/**************************************************************************/
/* GF02 ( テーブル定義 )                                                  */
/*                                                                        */
/* Created : 2010/08/02 13:05:59                                          */
/**************************************************************************/
CREATE TABLE GF02 (
   SYSTEM_ID       VARCHAR2(10)                 NOT NULL      /* 10  システムID               */
 , TBLSYU          VARCHAR2(1)                  NOT NULL      /* 20  テーブル種別             */
 , TABLE_NAME      VARCHAR2(50)                 NOT NULL      /* 30  テーブル名               */
 , NAME_JA         VARCHAR2(200)                              /* 40  名称                     */
 , TABLESPACE_NAME VARCHAR2(30)                 NOT NULL      /* 50  テーブルスペース名       */
 , INITIAL_AUTO    NUMBER(10)       DEFAULT 0   NOT NULL      /* 60  自動計算初期エクステント */
 , INITIAL_EXTENT  NUMBER(10)       DEFAULT 16  NOT NULL      /* 70  初期エクステント(KB)     */
 , NEXT_EXTENT     NUMBER(10)       DEFAULT 16  NOT NULL      /* 80  ＮＥＸＴエクステント     */
 , COMMENTS        VARCHAR2(500)                              /* 90  コメント                 */
 , SKENSU          NUMBER(9)        DEFAULT 0   NOT NULL      /* 170 想定件数                 */
 , JKENSU          NUMBER(9)        DEFAULT 0   NOT NULL      /* 180 実件数                   */
 , UNIQ            NUMBER(9)        DEFAULT 0   NOT NULL      /* 800 ユニークキー             */
 , FGJ             VARCHAR2(1)      DEFAULT '1' NOT NULL      /* 810 状態フラグ               */
 , DYSET           VARCHAR2(14)                               /* 820 登録日時                 */
 , PGSET           VARCHAR2(10)                               /* 830 作成PG                   */
 , PGPSET          VARCHAR2(10)                               /* 840 作成親PG                 */
 , USRSET          VARCHAR2(10)                               /* 850 作成社員                 */
 , DYUPD           VARCHAR2(14)                               /* 860 更新日時                 */
 , PGUPD           VARCHAR2(10)                               /* 870 更新PG                   */
 , PGPUPD          VARCHAR2(10)                               /* 880 更新親PG                 */
 , USRUPD          VARCHAR2(10)                               /* 890 更新者                   */
)
TABLESPACE GETBL01
STORAGE( INITIAL 320K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE GF02S00 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GF02T00 
BEFORE INSERT ON GF02
FOR EACH ROW 
BEGIN 
SELECT GF02S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

