/**************************************************************************/
/* GEA06 ( データロールマスタ )                                           */
/*                                                                        */
/* Created : 2010/08/02 13:05:57                                          */
/**************************************************************************/
CREATE TABLE GEA06 (
   SYSTEM_ID VARCHAR2(10)                 NOT NULL      /* 10  システムID   */
 , DROLE     VARCHAR2(20)                 NOT NULL      /* 20  データロール */
 , CLM       VARCHAR2(30)                 NOT NULL      /* 30  項目         */
 , CVALUE    VARCHAR2(200)                NOT NULL      /* 40  値           */
 , VALCDTN   VARCHAR2(10)                 NOT NULL      /* 50  条件         */
 , UNIQ      NUMBER(9)        DEFAULT 0   NOT NULL      /* 800 ユニークキー */
 , FGJ       VARCHAR2(1)      DEFAULT '1' NOT NULL      /* 810 状態フラグ   */
 , DYSET     VARCHAR2(14)                               /* 820 登録日時     */
 , USRSET    VARCHAR2(10)                               /* 850 作成社員     */
 , DYUPD     VARCHAR2(14)                               /* 860 更新日時     */
 , PGUPD     VARCHAR2(10)                               /* 870 更新PG       */
 , USRUPD    VARCHAR2(10)                               /* 890 更新者       */
)
TABLESPACE GETBL01
STORAGE( INITIAL 256K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE GEA06S00 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GEA06T00 
BEFORE INSERT ON GEA06
FOR EACH ROW 
BEGIN 
SELECT GEA06S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

